/*
 * Decompiled with CFR 0.152.
 */
package snownee.bathappy;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod(modid="bathappymod", name="Bat Happy Mod", version="2.0", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class BatHappy {
    public static final String MODID = "bathappymod";
    public static boolean win;
    public static long delay;
    public static final Item DUMMY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (!ModConfig.deluxe) {
            List modIds = Arrays.asList(ModConfig.batAngryModIds).stream().filter(modId -> !modId.equals(MODID)).filter(Loader::isModLoaded).collect(Collectors.toList());
            if (!modIds.isEmpty()) {
                CrashReport cr = CrashReport.func_85055_a((Throwable)new IllegalAccessError(), (String)String.format("The bat is angry because you are using following mods: %s", modIds.toString()));
                throw new ReportedException(cr);
            }
        } else {
            win = Arrays.asList(ModConfig.batAngryModIds).stream().filter(modId -> !modId.equals(MODID)).anyMatch(Loader::isModLoaded);
        }
    }

    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(DUMMY.setRegistryName("dummy"));
    }

    @SubscribeEvent
    public static void joinWorld(EntityJoinWorldEvent event) {
        if (!ModConfig.deluxe || !win) {
            return;
        }
        World world = event.getWorld();
        Entity entity = event.getEntity();
        if (world.field_72995_K || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        if (ModConfig.delayDeluxe) {
            if (delay < 0L) {
                delay = world.func_82737_E() + 144000L;
            } else if (world.func_82737_E() < delay) {
                return;
            }
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        player.field_71071_by.func_174888_l();
        player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 18000, 10));
        player.func_70690_d(new PotionEffect(MobEffects.field_180152_w, 18000, 10));
        player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 18000, 10));
        player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 18000, 10));
        player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 18000, 10));
        player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 18000, 10));
        player.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 18000, 10));
        player.field_71068_ca = 114513;
        player.func_82242_a(1);
        world.func_73046_m().func_71187_D().func_71556_a((ICommandSender)world.func_73046_m(), "advancement grant @a everything");
        String text = "\ufffd\ufffdcY\ufffd\ufffd6O\ufffd\ufffdeU\ufffd\ufffda W\ufffd\ufffdbI\ufffd\ufffddN";
        TextComponentString component = new TextComponentString(text);
        for (int i = 0; i < 6; ++i) {
            player.func_146105_b((ITextComponent)component, i == 0);
        }
        SPacketTitle spackettitle = new SPacketTitle(SPacketTitle.Type.TIMES, null, 20, 18000, 20);
        player.field_71135_a.func_147359_a((Packet)spackettitle);
        spackettitle = new SPacketTitle(SPacketTitle.Type.TITLE, (ITextComponent)component);
        player.field_71135_a.func_147359_a((Packet)spackettitle);
        spackettitle = new SPacketTitle(SPacketTitle.Type.SUBTITLE, (ITextComponent)component);
        player.field_71135_a.func_147359_a((Packet)spackettitle);
        Random rand = world.field_73012_v;
        for (int i = 0; i < 20; ++i) {
            EntitySheep sheep = new EntitySheep(world);
            sheep.func_96094_a("jeb_");
            sheep.func_175512_b(EnumDyeColor.func_176764_b((int)rand.nextInt(16)));
            sheep.func_146082_f((EntityPlayer)player);
            sheep.func_70080_a(player.field_70165_t + rand.nextDouble(), player.field_70163_u, player.field_70161_v + rand.nextDouble(), rand.nextFloat() * 360.0f, rand.nextFloat() * 360.0f);
            world.func_72838_d((Entity)sheep);
        }
        player.field_71071_by.field_70460_b.set(3, (Object)BatHappy.getStack("log"));
        NonNullList stacks = NonNullList.func_191196_a();
        stacks.add((Object)BatHappy.getStack("diamond_block"));
        stacks.add((Object)BatHappy.getStack("nether_star"));
        if (Loader.isModLoaded((String)"xijun")) {
            stacks.add((Object)BatHappy.getStack("xijun:faeces"));
        }
        if (Loader.isModLoaded((String)"projecte")) {
            stacks.add((Object)BatHappy.getStack("projecte:item.pe_time_watch"));
        }
        if (Loader.isModLoaded((String)"torcherino")) {
            stacks.add((Object)BatHappy.getStack("torcherino:blocktorcherino"));
        }
        for (int i = 0; i < 50; ++i) {
            for (ItemStack stack : stacks) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            }
        }
        player.func_71033_a(GameType.CREATIVE);
        world.func_73046_m().func_147139_a(EnumDifficulty.EASY);
        EntityDragon dragon = new EntityDragon(world);
        dragon.func_70107_b(player.field_70165_t, player.field_70163_u + 10.0, player.field_70161_v);
        world.func_72838_d((Entity)dragon);
        dragon.func_70606_j(0.0f);
        dragon.func_70030_z();
    }

    private static ItemStack getStack(String id) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, 64).func_151001_c("\ufffd\ufffdcY\ufffd\ufffd6O\ufffd\ufffdeU\ufffd\ufffda W\ufffd\ufffdbI\ufffd\ufffddN");
    }

    static {
        delay = -1L;
        DUMMY = new Item();
    }

    @Config(modid="bathappymod")
    public static final class ModConfig {
        @Config.Comment(value={"Just for demonstrating. Does not represent the author's personal attitude."})
        public static String[] batAngryModIds = new String[]{"torcherino", "projecte", "xijun", "bacteria", "decon_table", "decomp_table", "deconstriction", "uncraftingtable"};
        @Config.Comment(value={"Deluxe mode"})
        public static boolean deluxe = false;
        @Config.Comment(value={"Delay deluxe mode effect after 2 hours"})
        public static boolean delayDeluxe = true;
    }
}

