/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelAxe;
import vazkii.botania.common.item.relic.ItemLokiRing;

public class ItemTerraAxe
extends ItemManasteelAxe
implements ISequentialBreaker {
    private static final int BLOCK_SWAP_RATE = 10;
    public static final int BLOCK_RANGE = 32;
    private static final int LEAF_BLOCK_RANGE = 3;
    private static final int MANA_PER_DAMAGE = 100;
    private static final TIntObjectHashMap<Set<BlockSwapper>> blockSwappers = new TIntObjectHashMap();

    public ItemTerraAxe() {
        super(BotaniaAPI.terrasteelToolMaterial, "terraAxe");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_185065_c = -3.0f;
        this.func_185043_a(new ResourceLocation("botania", "terraaxe_on"), (stack, world, entity) -> {
            if (entity instanceof EntityPlayer && !this.shouldBreak((EntityPlayer)entity)) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    private boolean shouldBreak(EntityPlayer player) {
        return !player.func_70093_af() && !ItemTemperanceStone.hasTemperanceActive(player);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        RayTraceResult raycast = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
        if (raycast != null) {
            this.breakOtherBlock(player, stack, pos, pos, raycast.field_178784_b);
            ItemLokiRing.breakOnAllCursors(player, (Item)this, stack, pos, raycast.field_178784_b);
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(EntityPlayer player, ItemStack stack, BlockPos pos, BlockPos originPos, EnumFacing side) {
        if (this.shouldBreak(player)) {
            ItemTerraAxe.addBlockSwapper(player.field_70170_p, player, stack, pos, 32, true);
        }
    }

    @Override
    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.field_73011_w.getDimension())) {
            Set swappers = (Set)blockSwappers.get(dim);
            Iterator swapper = swappers.iterator();
            while (swapper.hasNext()) {
                BlockSwapper next = (BlockSwapper)swapper.next();
                if (next != null && next.tick()) continue;
                swapper.remove();
            }
        }
    }

    private static void addBlockSwapper(World world, EntityPlayer player, ItemStack stack, BlockPos origCoords, int steps, boolean leaves) {
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, steps, leaves);
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.getDimension();
        if (!blockSwappers.containsKey(dim)) {
            blockSwappers.put(dim, new HashSet());
        }
        ((Set)blockSwappers.get(dim)).add(swapper);
    }

    private static class BlockSwapper {
        public static final int SINGLE_BLOCK_RADIUS = 1;
        private final World world;
        private final EntityPlayer player;
        private final ItemStack truncator;
        private final BlockPos origin;
        private final boolean treatLeavesSpecial;
        private final int range;
        private final PriorityQueue<SwapCandidate> candidateQueue;
        private final Set<BlockPos> completedCoords;

        public BlockSwapper(World world, EntityPlayer player, ItemStack truncator, BlockPos origCoords, int range, boolean leaves) {
            this.world = world;
            this.player = player;
            this.truncator = truncator;
            this.origin = origCoords;
            this.range = range;
            this.treatLeavesSpecial = leaves;
            this.candidateQueue = new PriorityQueue();
            this.completedCoords = new HashSet<BlockPos>();
            this.candidateQueue.offer(new SwapCandidate(this.origin, this.range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate cand = this.candidateQueue.poll();
                if (this.completedCoords.contains(cand.coordinates) || cand.range <= 0) continue;
                ToolCommons.removeBlockWithDrops(this.player, this.truncator, this.world, cand.coordinates, state -> ToolCommons.materialsAxe.contains(state.func_185904_a()), false, this.treatLeavesSpecial);
                --remainingSwaps;
                this.completedCoords.add(cand.coordinates);
                for (BlockPos adj : this.adjacent(cand.coordinates)) {
                    Block block = this.world.func_180495_p(adj).func_177230_c();
                    boolean isWood = block.isWood((IBlockAccess)this.world, adj);
                    boolean isLeaf = block.isLeaves(this.world.func_180495_p(adj), (IBlockAccess)this.world, adj);
                    if (!isWood && !isLeaf) continue;
                    int newRange = this.treatLeavesSpecial && isLeaf ? Math.min(3, cand.range - 1) : cand.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<BlockPos> adjacent(BlockPos original) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.func_177982_a(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public static final class SwapCandidate
        implements Comparable<SwapCandidate> {
            public final BlockPos coordinates;
            public final int range;

            public SwapCandidate(BlockPos coordinates, int range) {
                this.coordinates = coordinates;
                this.range = range;
            }

            @Override
            public int compareTo(@Nonnull SwapCandidate other) {
                return other.range - this.range;
            }

            public boolean equals(Object other) {
                if (!(other instanceof SwapCandidate)) {
                    return false;
                }
                SwapCandidate cand = (SwapCandidate)other;
                return this.coordinates.equals((Object)cand.coordinates) && this.range == cand.range;
            }

            public int hashCode() {
                return Objects.hash(this.coordinates, this.range);
            }
        }
    }
}

