/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;

public class UseItemSuccessTrigger
implements ICriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("botania", "use_item_success");
    public static final UseItemSuccessTrigger INSTANCE = new UseItemSuccessTrigger();
    private final Map<PlayerAdvancements, PlayerTracker> playerTrackers = new HashMap<PlayerAdvancements, PlayerTracker>();

    private UseItemSuccessTrigger() {
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        this.playerTrackers.computeIfAbsent((PlayerAdvancements)player, (Function<PlayerAdvancements, PlayerTracker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.advancements.PlayerAdvancements ), (Lnet/minecraft/advancements/PlayerAdvancements;)Lvazkii/botania/common/advancements/UseItemSuccessTrigger$PlayerTracker;)()).listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        PlayerTracker tracker = this.playerTrackers.get(player);
        if (tracker != null) {
            tracker.listeners.remove(listener);
            if (tracker.listeners.isEmpty()) {
                this.playerTrackers.remove(player);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements player) {
        this.playerTrackers.remove(player);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return new Instance(ItemPredicate.func_192492_a((JsonElement)json.get("item")), LocationPredicate.func_193454_a((JsonElement)json.get("location")));
    }

    public void trigger(EntityPlayerMP player, ItemStack stack, WorldServer world, double x, double y, double z) {
        PlayerTracker tracker = this.playerTrackers.get(player.func_192039_O());
        if (tracker != null) {
            tracker.trigger(player, stack, world, x, y, z);
        }
    }

    static class Instance
    implements ICriterionInstance {
        private final ItemPredicate item;
        private final LocationPredicate location;

        Instance(ItemPredicate count, LocationPredicate indexPos) {
            this.item = count;
            this.location = indexPos;
        }

        @Nonnull
        public ResourceLocation func_192244_a() {
            return ID;
        }

        boolean test(ItemStack stack, WorldServer world, double x, double y, double z) {
            return this.item.func_192493_a(stack) && this.location.func_193452_a(world, x, y, z);
        }
    }

    static class PlayerTracker {
        private final PlayerAdvancements playerAdvancements;
        final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        PlayerTracker(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public void trigger(EntityPlayerMP player, ItemStack stack, WorldServer world, double x, double y, double z) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(stack, world, x, y, z)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }
}

