/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.render.entity.RenderSparkBase;
import vazkii.botania.common.entity.EntityCorporeaSpark;

public class RenderCorporeaSpark
extends RenderSparkBase<EntityCorporeaSpark> {
    public RenderCorporeaSpark(RenderManager manager) {
        super(manager);
    }

    @Override
    public TextureAtlasSprite getBaseIcon(EntityCorporeaSpark entity) {
        return entity.isMaster() ? MiscellaneousIcons.INSTANCE.corporeaWorldIconMaster : MiscellaneousIcons.INSTANCE.corporeaWorldIcon;
    }

    @Override
    public void colorSpinningIcon(EntityCorporeaSpark entity, float a) {
        int hex = entity.getNetwork().func_193350_e();
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)a);
    }

    @Override
    public TextureAtlasSprite getSpinningIcon(EntityCorporeaSpark entity) {
        return MiscellaneousIcons.INSTANCE.corporeaIconStar;
    }

    @Override
    public void renderCallback(EntityCorporeaSpark entity, float pticks) {
        int time = entity.getItemDisplayTicks();
        if (time == 0) {
            return;
        }
        float absTime = (float)Math.abs(time) - pticks;
        ItemStack stack = entity.getDisplayedItem();
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float scalef = 0.16666667f;
        GlStateManager.func_179152_a((float)scalef, (float)scalef, (float)scalef);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(absTime / 10.0f));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-2.0f + (time < 0 ? -absTime : absTime) / 6.0f));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, entity.field_70170_p, null).func_177554_e();
        if (icon != null) {
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            int pieces = 8;
            float stepU = (maxU - minU) / (float)pieces;
            float stepV = (maxV - minV) / (float)pieces;
            float gap = 1.0f + (time > 0 ? 10.0f - absTime : absTime) * 0.2f;
            int shift = pieces / 2;
            float scale = 1.0f / (float)pieces * 3.0f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            for (int i = -shift; i < shift; ++i) {
                GlStateManager.func_179109_b((float)(gap * (float)i), (float)0.0f, (float)0.0f);
                for (int j = -shift; j < shift; ++j) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(gap * (float)j), (float)0.0f);
                    IconHelper.renderIconIn3D(Tessellator.func_178181_a(), minU + stepU * (float)(i + shift), minV + stepV * (float)(j + shift + 1), minU + stepU * (float)(i + shift + 1), minV + stepV * (float)(j + shift), icon.func_94211_a() / pieces, icon.func_94216_b() / pieces, 0.125f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(-gap * (float)j), (float)0.0f);
                }
                GlStateManager.func_179109_b((float)(-gap * (float)i), (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

