/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile.signature;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.api.subtile.signature.SubTileSignature;

public class BasicSignature
implements SubTileSignature {
    private final String name;

    public BasicSignature(String name) {
        this.name = name;
    }

    @Override
    public String getUnlocalizedNameForStack(ItemStack stack) {
        return this.unlocalizedName("");
    }

    @Override
    public String getUnlocalizedLoreTextForStack(ItemStack stack) {
        return this.unlocalizedName(".reference");
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        Class<? extends SubTileEntity> clazz = BotaniaAPI.getSubTileMapping(this.name);
        if (clazz == null) {
            return "uwotm8";
        }
        if (SubTileGenerating.class.isAssignableFrom(clazz)) {
            return "botania.flowerType.generating";
        }
        if (SubTileFunctional.class.isAssignableFrom(clazz)) {
            return "botania.flowerType.functional";
        }
        return "botania.flowerType.misc";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltip(ItemStack stack, World world, List<String> tooltip) {
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)this.getType()));
    }

    private String unlocalizedName(String end) {
        return "tile.botania:flower." + this.name + end;
    }
}

