/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.tiles;

import exnihilocreatio.config.ModConfig;
import exnihilocreatio.rotationalPower.CapabilityRotationalMember;
import exnihilocreatio.rotationalPower.IRotationalPowerConsumer;
import exnihilocreatio.tiles.BaseTileEntity;
import exnihilocreatio.tiles.ItemHandlerAutoSifter;
import exnihilocreatio.tiles.TileSieve;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.Util;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Point3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAutoSifter
extends BaseTileEntity
implements ITickable,
IRotationalPowerConsumer {
    public final List<Tuple<Point3f, EnumFacing.Axis>> connectionPieces = new ArrayList<Tuple<Point3f, EnumFacing.Axis>>();
    public final ItemHandlerAutoSifter itemHandlerAutoSifter;
    public TileSieve[][] toSift = null;
    public EnumFacing facing = EnumFacing.NORTH;
    private int tickCounter = 0;
    public float rotationValue = 0.0f;
    public float perTickRotation = 0.0f;
    public float storedRotationalPower = 0.0f;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public float offsetZ = 0.0f;

    public TileAutoSifter() {
        this.itemHandlerAutoSifter = new ItemHandlerAutoSifter();
        this.itemHandlerAutoSifter.setTe(this);
    }

    public void func_73660_a() {
        ++this.tickCounter;
        int rotationSpeed = 10;
        if (this.field_145850_b.field_72995_K && this.perTickRotation != 0.0f) {
            this.offsetX = ModConfig.client.clientAutoSieveDisplacement * (float)Math.cos((double)((float)this.tickCounter * 2.0f) * Math.PI / (double)rotationSpeed);
            this.offsetZ = ModConfig.client.clientAutoSieveDisplacement * (float)Math.sin((double)((float)this.tickCounter * 2.0f) * Math.PI / (double)rotationSpeed);
        }
        if (this.tickCounter > 0 && this.tickCounter % rotationSpeed == 0) {
            this.perTickRotation = this.calcEffectivePerTickRotation(this.field_145850_b, this.field_174879_c, this.facing);
            this.updateToSift();
            this.tickCounter = 0;
        }
        this.storedRotationalPower += this.perTickRotation;
        if (Math.abs(this.storedRotationalPower) > 100.0f && this.toSift != null) {
            this.storedRotationalPower += this.storedRotationalPower > 0.0f ? -100.0f : 100.0f;
            if (!this.field_145850_b.field_72995_K) {
                this.doAutoSieving(this.toSift);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.rotationValue += this.perTickRotation;
            if (this.tickCounter % rotationSpeed == 0) {
                this.calculateConnectionPieces();
            }
        }
    }

    private void updateToSift() {
        BlockPos posOther = this.field_174879_c.func_177984_a();
        TileEntity te = this.field_145850_b.func_175625_s(posOther);
        this.toSift = te instanceof TileSieve ? this.collectPossibleSieves((TileSieve)te) : (TileSieve[][])null;
    }

    private void calculateConnectionPieces() {
        this.connectionPieces.clear();
        if (this.toSift != null) {
            for (int x = 0; x < this.toSift.length; ++x) {
                for (int z = 0; z < this.toSift.length; ++z) {
                    if (this.toSift[x][z] == null) continue;
                    if (x + 1 < this.toSift.length && this.toSift[x + 1][z] != null) {
                        this.connectionPieces.add((Tuple<Point3f, EnumFacing.Axis>)new Tuple((Object)new Point3f((float)x + 0.5f - (float)ModConfig.sieve.autoSieveRadius, 0.3f, (float)(z - ModConfig.sieve.autoSieveRadius)), (Object)EnumFacing.Axis.X));
                    }
                    if (z + 1 >= this.toSift.length || this.toSift[x][z + 1] == null) continue;
                    this.connectionPieces.add((Tuple<Point3f, EnumFacing.Axis>)new Tuple((Object)new Point3f((float)(x - ModConfig.sieve.autoSieveRadius), 0.3f, (float)z + 0.5f - (float)ModConfig.sieve.autoSieveRadius), (Object)EnumFacing.Axis.Z));
                }
            }
        }
    }

    private TileSieve[][] collectPossibleSieves(TileSieve thisSieve) {
        BlockPos curPos;
        BlockPos sievePos = thisSieve.func_174877_v();
        TileSieve[][] sieveMap = new TileSieve[ModConfig.sieve.autoSieveRadius * 2 + 1][ModConfig.sieve.autoSieveRadius * 2 + 1];
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(sievePos);
        while (!toCheck.isEmpty() && (curPos = (BlockPos)toCheck.poll()) != null) {
            int iZ;
            int iX = curPos.func_177958_n() - sievePos.func_177958_n() + ModConfig.sieve.autoSieveRadius;
            if (!this.validIndex(iX, iZ = curPos.func_177952_p() - sievePos.func_177952_p() + ModConfig.sieve.autoSieveRadius) || sieveMap[iX][iZ] != null || !this.isValidPartnerSieve(this.field_145850_b.func_175625_s(curPos))) continue;
            sieveMap[iX][iZ] = (TileSieve)this.field_145850_b.func_175625_s(curPos);
            for (EnumFacing face : EnumFacing.field_176754_o) {
                toCheck.add(curPos.func_177972_a(face));
            }
        }
        return sieveMap;
    }

    public boolean isConnected(TileSieve sieve) {
        int iX = sieve.func_174877_v().func_177958_n() - this.field_174879_c.func_177958_n() + ModConfig.sieve.autoSieveRadius;
        int iZ = sieve.func_174877_v().func_177952_p() - this.field_174879_c.func_177952_p() + ModConfig.sieve.autoSieveRadius;
        int dy = sieve.func_174877_v().func_177956_o() - this.field_174879_c.func_177956_o();
        return dy == 1 && this.toSift[iX][iZ] != null;
    }

    private boolean validIndex(int x, int z) {
        return x >= 0 && x < 2 * ModConfig.sieve.autoSieveRadius + 1 && z >= 0 && z < 2 * ModConfig.sieve.autoSieveRadius + 1;
    }

    private boolean isValidPartnerSieve(TileEntity tileOther) {
        if (tileOther instanceof TileSieve) {
            TileSieve sieve = (TileSieve)tileOther;
            sieve.validateAutoSieve();
            if (sieve.autoSifter == this) {
                return true;
            }
            if (sieve.autoSifter == null) {
                sieve.autoSifter = this;
                return true;
            }
        }
        return false;
    }

    private void doAutoSieving(TileSieve[][] sieveMap) {
        TileSieve[][] tileSieveArray = sieveMap;
        int n = tileSieveArray.length;
        for (int i = 0; i < n; ++i) {
            TileSieve[] tileSieves;
            for (TileSieve tileSieve : tileSieves = tileSieveArray[i]) {
                if (tileSieve == null) continue;
                if (!this.itemHandlerAutoSifter.getStackInSlot(0).func_190926_b() && tileSieve.addBlock(this.itemHandlerAutoSifter.getStackInSlot(0))) {
                    this.itemHandlerAutoSifter.getStackInSlot(0).func_190918_g(1);
                }
                tileSieve.doSieving(null, true);
            }
        }
    }

    @Override
    public float getMachineRotationPerTick() {
        return this.perTickRotation;
    }

    @Override
    public void setEffectivePerTickRotation(float rotation) {
        this.perTickRotation = rotation;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerAutoSifter);
        }
        if (capability == CapabilityRotationalMember.ROTIONAL_MEMBER) {
            return (T)CapabilityRotationalMember.ROTIONAL_MEMBER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityRotationalMember.ROTIONAL_MEMBER && facing == this.facing || super.hasCapability(capability, facing);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound itemHandlerTag = this.itemHandlerAutoSifter.serializeNBT();
        tag.func_74782_a("itemHandler", (NBTBase)itemHandlerTag);
        if (this.facing != null) {
            tag.func_74778_a("facing", this.facing.func_176610_l());
        }
        tag.func_74776_a("rot", this.rotationValue);
        tag.func_74776_a("sRot", this.storedRotationalPower);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("itemHandler")) {
            this.itemHandlerAutoSifter.deserializeNBT((NBTTagCompound)tag.func_74781_a("itemHandler"));
        }
        if (tag.func_74764_b("facing")) {
            this.facing = EnumFacing.func_176739_a((String)tag.func_74779_i("facing"));
        }
        if (tag.func_74764_b("rot")) {
            this.rotationValue = tag.func_74760_g("rot");
        }
        if (tag.func_74764_b("sRot")) {
            this.storedRotationalPower = tag.func_74760_g("sRot");
        }
        super.func_145839_a(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        if (!this.itemHandlerAutoSifter.getStackInSlot(0).func_190926_b()) {
            return Util.getTextureFromBlockState(new BlockInfo(this.itemHandlerAutoSifter.getStackInSlot(0)).getBlockState());
        }
        return null;
    }
}

