/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries.prefab;

import com.google.gson.Gson;
import exnihilocreatio.api.registries.IRegistry;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.registries.manager.IDefaultRecipeProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BaseRegistry<RegType>
implements IRegistry<RegType> {
    protected final Gson gson;
    private final List<? extends IDefaultRecipeProvider> defaultRecipeProviders;
    protected boolean hasAlreadyBeenLoaded = false;
    protected RegType registry;
    protected Type typeOfSource;

    public BaseRegistry(Gson gson, RegType registry, Type typeOfSource, @Nonnull List<? extends IDefaultRecipeProvider> defaultRecipeProviders) {
        this.gson = gson;
        this.registry = registry;
        this.typeOfSource = typeOfSource;
        this.defaultRecipeProviders = defaultRecipeProviders;
    }

    public void saveJson(File file) {
        try (FileWriter fw = new FileWriter(file);){
            if (this.typeOfSource != null) {
                this.gson.toJson(this.registry, this.typeOfSource, (Appendable)fw);
            } else {
                this.gson.toJson(this.registry, (Appendable)fw);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadJson(File file) {
        if (this.hasAlreadyBeenLoaded) {
            this.clearRegistry();
        }
        if (file.exists() && ModConfig.misc.enableJSONLoading) {
            try (FileReader fr = new FileReader(file);){
                this.registerEntriesFromJSON(fr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.registerDefaults();
            if (ModConfig.misc.enableJSONLoading) {
                this.saveJson(file);
            }
        }
        this.hasAlreadyBeenLoaded = true;
    }

    protected abstract void registerEntriesFromJSON(FileReader var1);

    public void registerDefaults() {
        this.defaultRecipeProviders.forEach(recipeProvider -> recipeProvider.registerRecipeDefaults(this));
    }

    public abstract List<?> getRecipeList();

    @Override
    public abstract void clearRegistry();

    @Override
    public RegType getRegistry() {
        return this.registry;
    }

    public Type getTypeOfSource() {
        return this.typeOfSource;
    }
}

