/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.ingredient;

import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.util.LogUtil;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;

public class IngredientUtil {
    public static Ingredient parseFromString(String s) {
        if (s.startsWith("ore:")) {
            s = s.substring(4);
            return new OreIngredientStoring(s);
        }
        String[] split = s.split(":");
        if (split.length >= 2) {
            Item item = Item.func_111206_d((String)(split[0] + ":" + split[1]));
            if (item == null) {
                LogUtil.error("Error parsing Ingredient String: Invalid Item: " + s);
                return Ingredient.field_193370_a;
            }
            if (split.length >= 3) {
                try {
                    int meta = Integer.parseInt(split[2]);
                    ItemStack stack = new ItemStack(item, 1, meta);
                    return CraftingHelper.getIngredient((Object)stack);
                }
                catch (NumberFormatException ignored) {
                    LogUtil.error("Number error in json: " + s);
                }
            } else {
                return CraftingHelper.getIngredient((Object)item);
            }
        }
        return Ingredient.field_193370_a;
    }

    public static boolean ingredientEquals(Ingredient ingr1, Ingredient ingr2) {
        if (ingr1 instanceof OreIngredientStoring && ingr2 instanceof OreIngredientStoring) {
            return Objects.equals(((OreIngredientStoring)ingr1).getOreName(), ((OreIngredientStoring)ingr2).getOreName());
        }
        return ingr1.func_194139_b().equals(ingr2.func_194139_b());
    }
}

