/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.modules.forestry.registry;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.modules.forestry.registry.HiveRequirements;
import exnihilocreatio.util.BlockInfo;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/modules/forestry/registry/CustomHiveRequirementsJson;", "Lcom/google/gson/JsonDeserializer;", "Lexnihilocreatio/modules/forestry/registry/HiveRequirements;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomHiveRequirementsJson
implements JsonDeserializer<HiveRequirements>,
JsonSerializer<HiveRequirements> {
    public static final CustomHiveRequirementsJson INSTANCE;

    @NotNull
    public JsonElement serialize(@NotNull HiveRequirements src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        JsonObject jsonObject;
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject $receiver = jsonObject = new JsonObject();
        $receiver.add("hive", context.serialize((Object)src.getHive()));
        $receiver.addProperty("dim", (Number)src.getDimension());
        $receiver.addProperty("minTemperature", (Number)src.getMinTemperature());
        $receiver.addProperty("maxTemperature", (Number)src.getMaxTemperature());
        $receiver.addProperty("minLight", (Number)src.getMinLight());
        $receiver.addProperty("maxLight", (Number)src.getMaxLight());
        $receiver.addProperty("minElevation", (Number)src.getMinElevation());
        $receiver.addProperty("maxElevation", (Number)src.getMaxElevation());
        if (src.getAllowedBiomes() != null) {
            $receiver.add("allowedBiomes", context.serialize(src.getAllowedBiomes()));
        }
        if (!src.getAdjacentBlocks().isEmpty()) {
            $receiver.add("adjacentBlocks", context.serialize(src.getAdjacentBlocks()));
        }
        if (!src.getNearbyBlocks().isEmpty()) {
            $receiver.add("nearbyBlocks", context.serialize(src.getNearbyBlocks()));
        }
        return (JsonElement)jsonObject;
    }

    @NotNull
    public HiveRequirements deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonHelper helper = new JsonHelper(json);
        BlockInfo hive = new BlockInfo(helper.getString("hive"));
        int dimension = helper.getInteger("dim");
        float minT = helper.getNullableFloat("minTemperature", 0.0f);
        float maxT = helper.getNullableFloat("maxTemperature", 1000.0f);
        int minL = helper.getNullableInteger("minLight", 0);
        int maxL = helper.getNullableInteger("maxLight", 15);
        int minY = helper.getNullableInteger("minElevation", 0);
        int maxY = helper.getNullableInteger("maxElevation", 255);
        Set allowedBiomes = new HashSet();
        if (json.getAsJsonObject().has("allowedBiomes")) {
            Object object = context.deserialize(json.getAsJsonObject().get("allowedBiomes"), (Type)((Object)Set.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.deserialize<Set<\u2026iomes\"), Set::class.java)");
            allowedBiomes = (Set)object;
        }
        Map adjBlocks = new HashMap();
        if (json.getAsJsonObject().has("adjBlocks")) {
            Object object = context.deserialize(json.getAsJsonObject().get("adjBlocks"), (Type)((Object)Map.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.deserialize<Map<\u2026locks\"), Map::class.java)");
            adjBlocks = (Map)object;
        }
        Map nearBlocks = new HashMap();
        if (json.getAsJsonObject().has("nearBlocks")) {
            Object object = context.deserialize(json.getAsJsonObject().get("nearBlocks"), (Type)((Object)Map.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.deserialize<Map<\u2026locks\"), Map::class.java)");
            nearBlocks = (Map)object;
        }
        return new HiveRequirements(hive, dimension, allowedBiomes, Float.valueOf(minT), Float.valueOf(maxT), minL, maxL, minY, maxY, adjBlocks, nearBlocks);
    }

    private CustomHiveRequirementsJson() {
    }

    static {
        CustomHiveRequirementsJson customHiveRequirementsJson;
        INSTANCE = customHiveRequirementsJson = new CustomHiveRequirementsJson();
    }
}

