/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.modules.forestry.blocks;

import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.modules.Forestry;
import exnihilocreatio.modules.forestry.registry.HiveRequirements;
import exnihilocreatio.util.IHasModel;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BlockHive
extends Block
implements IHasModel {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockHive(Material mat, String name) {
        super(mat);
        this.setRegistryName(name);
        this.func_149663_c("exnihilocreatio." + name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.ARTIFICIAL)));
        this.func_149647_a(ExNihiloCreatio.tabExNihilo);
        this.func_149675_a(true);
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType enumtype : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, enumtype.getMetadata()));
        }
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @NotNull
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (state.func_177229_b(VARIANT) == EnumType.ARTIFICIAL) {
            return;
        }
        for (int i = 0; i < ModConfig.compatibility.forestry_compat.hiveTransformTrys; ++i) {
            HiveRequirements req = (HiveRequirements)((List)Forestry.HIVE_REQUIREMENTS_REGISTRY.getRegistry()).get(rand.nextInt(((List)Forestry.HIVE_REQUIREMENTS_REGISTRY.getRegistry()).size()));
            if (!req.check(world, pos)) continue;
            world.func_175656_a(pos, req.getHive().getBlockState());
            return;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel(ModelRegistryEvent e) {
        for (int i = 0; i < EnumType.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "variant=" + EnumType.values()[i].func_176610_l()));
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        ARTIFICIAL(0, "artificial_hive", MapColor.field_151673_t),
        SCENTED(1, "scented_hive", MapColor.field_151650_B);

        private final int metadata;
        private final String name;
        private final String translationKey;
        private final MapColor mapColor;

        private EnumType(int meta, String name, MapColor color) {
            this.metadata = meta;
            this.name = name;
            this.translationKey = "tile.exnihilocreatio.hive." + name;
            this.mapColor = color;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String func_176610_l() {
            return this.name;
        }
    }
}

