/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.modules.forestry;

import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.StackInfo;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import net.minecraft.item.ItemStack;

public class ForestryHelper {
    public static StackInfo getDroneInfo(String species) {
        return new ItemInfo(ForestryHelper.getBeeStack(species, EnumBeeType.DRONE, false));
    }

    public static StackInfo getPristineInfo(String species) {
        return new ItemInfo(ForestryHelper.getBeeStack(species, EnumBeeType.PRINCESS, true));
    }

    public static StackInfo getIgnobleInfo(String species) {
        return new ItemInfo(ForestryHelper.getBeeStack(species, EnumBeeType.PRINCESS, false));
    }

    public static ItemStack getBeeStack(String speciesName, EnumBeeType beeType, boolean isPristine) {
        IAlleleBeeSpecies species = null;
        for (String uid : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            IAllele allele;
            if (!uid.equals(speciesName) || !((allele = AlleleManager.alleleRegistry.getAllele(uid)) instanceof IAlleleBeeSpecies)) continue;
            species = (IAlleleBeeSpecies)allele;
            break;
        }
        if (species == null) {
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleBeeSpecies) || !allele.getAlleleName().equals(speciesName)) continue;
                species = (IAlleleBeeSpecies)allele;
                break;
            }
        }
        if (species == null) {
            LogUtil.error("Could not find bee species: " + speciesName);
            return ItemStack.field_190927_a;
        }
        IAllele[] template = BeeManager.beeRoot.getTemplate(species);
        IBeeGenome genome = BeeManager.beeRoot.templateAsGenome(template);
        IBee bee = BeeManager.beeRoot.getBee(genome);
        if (beeType.equals((Object)EnumBeeType.PRINCESS)) {
            bee.setIsNatural(isPristine);
        }
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)beeType);
    }
}

