/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/json/CustomItemStackJson;", "Lcom/google/gson/JsonDeserializer;", "Lnet/minecraft/item/ItemStack;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomItemStackJson
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    public static final CustomItemStackJson INSTANCE;

    @NotNull
    public ItemStack deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonHelper helper = new JsonHelper(json);
        String name = helper.getString("name");
        int amount = helper.getNullableInteger("amount", 1);
        int meta = helper.getNullableInteger("meta", 0);
        Item item = Item.func_111206_d((String)name);
        if (item == null) {
            LogUtil.error("Error parsing JSON: Invalid Item: " + json);
            LogUtil.error("This may result in crashing or other undefined behavior");
            Item item2 = Items.field_190931_a;
            item = item2;
            Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"doInline {\n            L\u2026nline Items.AIR\n        }");
        }
        Item item3 = item;
        ItemStack stack = new ItemStack(item3, amount, meta);
        if (json.getAsJsonObject().has("nbt")) {
            try {
                JsonElement jsonElement = json.getAsJsonObject().get("nbt");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json.asJsonObject.get(\"nbt\")");
                stack.func_77982_d(JsonToNBT.func_180713_a((String)jsonElement.getAsString()));
            }
            catch (NBTException e) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not convert JSON to NBT: ");
                JsonElement jsonElement = json.getAsJsonObject().get("nbt");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json.asJsonObject.get(\"nbt\")");
                LogUtil.error(stringBuilder.append(jsonElement.getAsString()).toString(), e);
                e.printStackTrace();
            }
        }
        return stack;
    }

    @NotNull
    public JsonElement serialize(@NotNull ItemStack src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject jsonObject = new JsonObject();
        Item item = src.func_77973_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"src.item");
        if (item.getRegistryName() == null) {
            string = "";
        } else {
            Item item2 = src.func_77973_b();
            Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"src.item");
            ResourceLocation resourceLocation = item2.getRegistryName();
            if (resourceLocation == null) {
                Intrinsics.throwNpe();
            }
            String string2 = resourceLocation.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"src.item.registryName!!.toString()");
        }
        jsonObject.addProperty("name", string);
        jsonObject.addProperty("amount", (Number)src.func_190916_E());
        jsonObject.addProperty("meta", (Number)src.func_77952_i());
        NBTTagCompound nbt = src.func_77978_p();
        if (nbt != null && !nbt.func_82582_d()) {
            jsonObject.addProperty("nbt", nbt.toString());
        }
        return (JsonElement)jsonObject;
    }

    private CustomItemStackJson() {
    }

    static {
        CustomItemStackJson customItemStackJson;
        INSTANCE = customItemStackJson = new CustomItemStackJson();
    }
}

