/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/json/CustomIngredientJson;", "Lcom/google/gson/JsonDeserializer;", "Lnet/minecraft/item/crafting/Ingredient;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomIngredientJson
implements JsonDeserializer<Ingredient>,
JsonSerializer<Ingredient> {
    public static final CustomIngredientJson INSTANCE;

    @NotNull
    public Ingredient deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (json.isJsonPrimitive() && ((JsonPrimitive)json).isString()) {
            String s = json.getAsString();
            Ingredient ingredient = IngredientUtil.parseFromString(s);
            Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"IngredientUtil.parseFromString(s)");
            return ingredient;
        }
        LogUtil.error("Error parsing JSON: No Primitive String: " + json);
        Ingredient ingredient = Ingredient.field_193370_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"Ingredient.EMPTY");
        return ingredient;
    }

    @NotNull
    public JsonElement serialize(@NotNull Ingredient src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        ItemStack[] itemStackArray;
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (src instanceof OreIngredientStoring) {
            return (JsonElement)new JsonPrimitive("ore:" + ((OreIngredientStoring)src).getOreName());
        }
        ItemStack[] stacks = src.func_193365_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)stacks, (String)"stacks");
        ItemStack[] itemStackArray2 = itemStackArray = stacks;
        if (!(itemStackArray2.length == 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            ItemStack itemStack = stacks[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stacks[0]");
            Item item = itemStack.func_77973_b();
            Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"stacks[0].item");
            ResourceLocation resourceLocation = item.getRegistryName();
            if (resourceLocation == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder stringBuilder2 = stringBuilder.append(resourceLocation.toString()).append(":");
            ItemStack itemStack2 = stacks[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"stacks[0]");
            return (JsonElement)new JsonPrimitive(stringBuilder2.append(itemStack2.func_77960_j()).toString());
        }
        return (JsonElement)new JsonPrimitive("minecraft:air:0");
    }

    private CustomIngredientJson() {
    }

    static {
        CustomIngredientJson customIngredientJson;
        INSTANCE = customIngredientJson = new CustomIngredientJson();
    }
}

