/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei;

import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.ModBlocks;
import exnihilocreatio.compatibility.jei.IgnoreNBTandMetaInterpreter;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipe;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluiditemtransform.FluidItemTransformRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluiditemtransform.FluidItemTransformRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipeCategory;
import exnihilocreatio.compatibility.jei.crook.CrookRecipe;
import exnihilocreatio.compatibility.jei.crook.CrookRecipeCategory;
import exnihilocreatio.compatibility.jei.crucible.CrucibleHeatSourceRecipeCategory;
import exnihilocreatio.compatibility.jei.crucible.CrucibleRecipe;
import exnihilocreatio.compatibility.jei.crucible.CrucibleRecipeCategory;
import exnihilocreatio.compatibility.jei.crucible.HeatSourcesRecipe;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipe;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipeCategory;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipe;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipeCategory;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.modules.TinkersConstruct;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.util.ItemUtil;
import exnihilocreatio.util.LogUtil;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.TConstruct;

@JEIPlugin
public class CompatJEI
implements IModPlugin {
    private final ISubtypeRegistry.ISubtypeInterpreter interpreter = new IgnoreNBTandMetaInterpreter();

    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
        if (Loader.isModLoaded((String)"tconstruct") && TConstruct.pulseManager.isPulseLoaded("TinkerTools") && ModConfig.compatibility.tinkers_construct_compat.doTinkersConstructCompat && ModConfig.compatibility.tinkers_construct_compat.JEItinkersTools) {
            if (ModConfig.compatibility.tinkers_construct_compat.addExNihiloHammer) {
                subtypeRegistry.registerSubtypeInterpreter(TinkersConstruct.getHammer(), this.interpreter);
            }
            if (ModConfig.compatibility.tinkers_construct_compat.addExNihiloCrook) {
                subtypeRegistry.registerSubtypeInterpreter(TinkersConstruct.getCrook(), this.interpreter);
            }
        }
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new SieveRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new HammerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrookRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidOnTopRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidTransformRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidItemTransformRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, "exnihilocreatio:crucible_wood")});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, "exnihilocreatio:crucible_stone")});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleHeatSourceRecipeCategory(guiHelper)});
    }

    @SideOnly(value=Side.CLIENT)
    public void register(@Nonnull IModRegistry registry) {
        LogUtil.info("ModConfig Loaded: " + ExNihiloCreatio.configsLoaded);
        if (!ExNihiloCreatio.configsLoaded) {
            ExNihiloCreatio.loadConfigs();
        }
        this.registerCompost(registry);
        this.registerFluidBlockTransform(registry);
        this.registerFluidOnTop(registry);
        this.registerFluidTransform(registry);
        this.registerHammer(registry);
        this.registerCrook(registry);
        this.registerHeat(registry);
        this.registerSieve(registry);
        this.registerStoneCrucible(registry);
        this.registerWoodCrucible(registry);
        for (Item item : Item.field_150901_e) {
            if (ItemUtil.isHammer(item)) {
                registry.addRecipeCatalyst((Object)new ItemStack(item), new String[]{"exnihilocreatio:hammer"});
                LogUtil.info("Registered Hammer Catalyst: " + item.getRegistryName());
            }
            if (!ItemUtil.isCrook(item)) continue;
            registry.addRecipeCatalyst((Object)new ItemStack(item), new String[]{"exnihilocreatio:crook"});
            LogUtil.info("Registered Crook Catalyst: " + item.getRegistryName());
        }
    }

    private void registerCompost(@Nonnull IModRegistry registry) {
        List<CompostRecipe> compostRecipes = ExNihiloRegistryManager.COMPOST_REGISTRY.getRecipeList();
        registry.addRecipes(compostRecipes, "exnihilocreatio:compost");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:compost"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:compost"});
        LogUtil.info("JEI: Compost Recipe Pages Loaded:         " + compostRecipes.size());
    }

    private void registerFluidBlockTransform(@Nonnull IModRegistry registry) {
        List<FluidItemTransformRecipe> fluidItemTransformRecipes = ExNihiloRegistryManager.FLUID_BLOCK_TRANSFORMER_REGISTRY.getRecipeList();
        fluidItemTransformRecipes.addAll(ExNihiloRegistryManager.FLUID_ITEM_FLUID_REGISTRY.getRecipeList());
        registry.addRecipes(fluidItemTransformRecipes, "exnihilocreatio:fluid_block_transform");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_block_transform"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_block_transform"});
        LogUtil.info("JEI: Fluid Item Transform Recipes Loaded:       " + fluidItemTransformRecipes.size());
    }

    private void registerFluidOnTop(@Nonnull IModRegistry registry) {
        List<FluidOnTopRecipe> fluidOnTopRecipes = ExNihiloRegistryManager.FLUID_ON_TOP_REGISTRY.getRecipeList();
        registry.addRecipes(fluidOnTopRecipes, "exnihilocreatio:fluid_on_top");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_on_top"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_on_top"});
        LogUtil.info("JEI: Fluid On Top Recipes Loaded:       " + fluidOnTopRecipes.size());
    }

    private void registerFluidTransform(@Nonnull IModRegistry registry) {
        List<FluidTransformRecipe> fluidTransformRecipes = ExNihiloRegistryManager.FLUID_TRANSFORM_REGISTRY.getRecipeList();
        registry.addRecipes(fluidTransformRecipes, "exnihilocreatio:fluid_transform");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_transform"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_transform"});
        LogUtil.info("JEI: Fluid Transform Recipes Loaded:    " + fluidTransformRecipes.size());
    }

    private void registerHammer(@Nonnull IModRegistry registry) {
        List<HammerRecipe> hammerRecipes = ExNihiloRegistryManager.HAMMER_REGISTRY.getRecipeList();
        registry.addRecipes(hammerRecipes, "exnihilocreatio:hammer");
        LogUtil.info("JEI: Hammer Recipes Loaded:             " + hammerRecipes.size());
    }

    private void registerCrook(@Nonnull IModRegistry registry) {
        List<CrookRecipe> crookRecipes = ExNihiloRegistryManager.CROOK_REGISTRY.getRecipeList();
        registry.addRecipes(crookRecipes, "exnihilocreatio:crook");
        LogUtil.info("JEI: Crook Recipes Loaded:              " + crookRecipes.size());
    }

    private void registerHeat(@Nonnull IModRegistry registry) {
        List<HeatSourcesRecipe> heatSources = ExNihiloRegistryManager.HEAT_REGISTRY.getRecipeList();
        registry.addRecipes(heatSources, "exnihilocreatio:heat_sources");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crucibleStone, 1, 1), new String[]{"exnihilocreatio:heat_sources"});
        LogUtil.info("JEI: Heat Sources Loaded:             " + heatSources.size());
    }

    private void registerSieve(@Nonnull IModRegistry registry) {
        List<SieveRecipe> sieveRecipes = ExNihiloRegistryManager.SIEVE_REGISTRY.getRecipeList();
        registry.addRecipes(sieveRecipes, "exnihilocreatio:sieve");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.sieve), new String[]{"exnihilocreatio:sieve"});
        LogUtil.info("JEI: Sieve Recipes Loaded:              " + sieveRecipes.size());
    }

    private void registerStoneCrucible(@Nonnull IModRegistry registry) {
        List<CrucibleRecipe> crucibleRecipes = ExNihiloRegistryManager.CRUCIBLE_STONE_REGISTRY.getRecipeList();
        registry.addRecipes(crucibleRecipes, "exnihilocreatio:crucible_stone");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crucibleStone, 1, 1), new String[]{"exnihilocreatio:crucible_stone"});
        LogUtil.info("JEI: Stone Crucible Recipes Loaded:       " + crucibleRecipes.size());
    }

    private void registerWoodCrucible(@Nonnull IModRegistry registry) {
        List<CrucibleRecipe> crucibleRecipes = ExNihiloRegistryManager.CRUCIBLE_WOOD_REGISTRY.getRecipeList();
        registry.addRecipes(crucibleRecipes, "exnihilocreatio:crucible_wood");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crucibleWood, 1, 0), new String[]{"exnihilocreatio:crucible_wood"});
        LogUtil.info("JEI: Wood Crucible Recipes Loaded:        " + crucibleRecipes.size());
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
    }
}

