/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel.modes.fluid;

import exnihilocreatio.barrel.BarrelFluidHandler;
import exnihilocreatio.barrel.modes.mobspawn.BarrelModeMobSpawn;
import exnihilocreatio.items.ItemDoll;
import exnihilocreatio.networking.MessageBarrelModeUpdate;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.FluidBlockTransformer;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.EntityInfo;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelItemHandlerFluid
extends ItemStackHandler {
    private TileBarrel barrel;

    public BarrelItemHandlerFluid(TileBarrel barrel) {
        super(1);
        this.barrel = barrel;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        FluidBlockTransformer transformer;
        BarrelFluidHandler tank = this.barrel.getTank();
        if (tank.getFluid() == null) {
            return stack;
        }
        if (ExNihiloRegistryManager.FLUID_BLOCK_TRANSFORMER_REGISTRY.canBlockBeTransformedWithThisFluid(tank.getFluid().getFluid(), stack) && tank.getFluidAmount() == tank.getCapacity() && (transformer = ExNihiloRegistryManager.FLUID_BLOCK_TRANSFORMER_REGISTRY.getTransformation(tank.getFluid().getFluid(), stack)) != null) {
            BlockInfo info = transformer.getOutput();
            int spawnCount = transformer.getSpawnCount();
            if (!simulate) {
                tank.drain(tank.getCapacity(), true);
                this.barrel.setMode("block");
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("block", this.barrel.func_174877_v()), this.barrel);
                this.barrel.getMode().addItem(info.getItemStack(), this.barrel);
                if (spawnCount > 0) {
                    int spawnRange = transformer.getSpawnRange();
                    EntityInfo entityInfo = transformer.getToSpawn();
                    for (int i = 0; i < spawnCount; ++i) {
                        entityInfo.spawnEntityNear(this.barrel.func_174877_v(), spawnRange, this.barrel.func_145831_w());
                    }
                }
            }
            ItemStack ret = stack.func_77946_l();
            ret.func_190918_g(1);
            return ret.func_190926_b() ? ItemStack.field_190927_a : ret;
        }
        String fluidItemFluidOutput = ExNihiloRegistryManager.FLUID_ITEM_FLUID_REGISTRY.getFLuidForTransformation(tank.getFluid().getFluid(), stack);
        if (fluidItemFluidOutput != null && tank.getFluidAmount() == tank.getCapacity()) {
            if (!simulate) {
                tank.drain(tank.getCapacity(), true);
                this.barrel.setMode("fluid");
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("block", this.barrel.func_174877_v()), this.barrel);
                tank.fill(FluidRegistry.getFluidStack((String)fluidItemFluidOutput, (int)tank.getCapacity()), true);
                PacketHandler.sendNBTUpdate(this.barrel);
            }
            ItemStack ret = stack.func_77946_l();
            ret.func_190918_g(1);
            return ret.func_190926_b() ? ItemStack.field_190927_a : ret;
        }
        if (!stack.func_190926_b() && tank.getFluidAmount() == tank.getCapacity() && stack.func_77973_b() instanceof ItemDoll && ((ItemDoll)stack.func_77973_b()).getSpawnFluid(stack) == tank.getFluid().getFluid()) {
            if (!simulate) {
                this.barrel.getTank().drain(1000, true);
                this.barrel.setMode("mobspawn");
                ((BarrelModeMobSpawn)this.barrel.getMode()).setDollStack(stack);
                PacketHandler.sendNBTUpdate(this.barrel);
            }
            ItemStack ret = stack.func_77946_l();
            ret.func_190918_g(1);
            return ret;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public void setBarrel(TileBarrel barrel) {
        this.barrel = barrel;
    }
}

