/*
 * Decompiled with CFR 0.152.
 */
package shadows.endertweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.soul.ISoulBinderRecipe;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import shadows.endertweaker.EnderTweaker;
import shadows.endertweaker.recipe.SoulBinderRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.enderio.SoulBinder")
@ZenRegister
public class SoulBinder {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, String[] entities, int xp, @Optional int energyCost) {
        EnderTweaker.ADDITIONS.add(() -> MachineRecipeRegistry.instance.registerRecipe((IMachineRecipe)new SoulBinderRecipe(CraftTweakerMC.getIngredient((IIngredient)input), CraftTweakerMC.getItemStack((IItemStack)output), xp, energyCost <= 0 ? 5000 : energyCost, RecipeLevel.IGNORE, SoulBinder.toRelocs(entities))));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            CraftTweakerAPI.logError((String)"Cannot remove recipe for null from soul binder.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> {
            ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)output);
            String id = null;
            IMachineRecipe recipe = null;
            for (Map.Entry ent : MachineRecipeRegistry.instance.getRecipesForMachine("soulbinder").entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)((ISoulBinderRecipe)ent.getValue()).getOutputStack(), (boolean)false)) continue;
                id = (String)ent.getKey();
                recipe = (IMachineRecipe)ent.getValue();
                break;
            }
            if (id != null) {
                MachineRecipeRegistry.instance.removeRecipe(recipe);
            } else {
                CraftTweakerAPI.logError((String)("No Soul Binder recipe found for " + output.getDisplayName()));
            }
        });
    }

    public static ResourceLocation[] toRelocs(String[] ar) {
        ResourceLocation[] ret = new ResourceLocation[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            ret[i] = new ResourceLocation(ar[i]);
        }
        return ret;
    }
}

