/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.proxy;

import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.particles.ParticleHandler;
import de.ellpeck.naturesaura.particles.ParticleMagic;
import de.ellpeck.naturesaura.proxy.IProxy;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import de.ellpeck.naturesaura.renderers.PlayerLayerTrinkets;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
implements IProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        Compat.preInitClient();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        for (RenderPlayer render : new RenderPlayer[]{(RenderPlayer)skinMap.get("default"), (RenderPlayer)skinMap.get("slim")}) {
            render.func_177094_a((LayerRenderer)new PlayerLayerTrinkets());
        }
        new SupporterFancyHandler();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    public void registerRenderer(ItemStack stack, ModelResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)stack.func_77973_b(), (int)stack.func_77952_i(), (ModelResourceLocation)location);
    }

    @Override
    public void addColorProvidingItem(IColorProvidingItem item) {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        IItemColor color = item.getItemColor();
        if (item instanceof Item) {
            colors.func_186730_a(color, new Item[]{(Item)item});
        } else if (item instanceof Block) {
            colors.func_186731_a(color, new Block[]{(Block)item});
        }
    }

    @Override
    public void addColorProvidingBlock(IColorProvidingBlock block) {
        if (block instanceof Block) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(block.getBlockColor(), new Block[]{(Block)block});
        }
    }

    @Override
    public void registerTESR(ITESRProvider provider) {
        Tuple<Class, TileEntitySpecialRenderer> tesr = provider.getTESR();
        ClientRegistry.bindTileEntitySpecialRenderer((Class)((Class)tesr.func_76341_a()), (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)tesr.func_76340_b()));
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(Class<T> entityClass, Supplier<IRenderFactory<T>> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory.get());
    }

    @Override
    public void spawnMagicParticle(double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, float gravity, boolean collision, boolean fade) {
        ParticleHandler.spawnParticle(() -> new ParticleMagic((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, motionX, motionY, motionZ, color, scale, maxAge, gravity, collision, fade), posX, posY, posZ);
    }

    @Override
    public void setParticleDepth(boolean depth) {
        ParticleHandler.depthEnabled = depth;
    }

    @Override
    public void setParticleSpawnRange(int range) {
        ParticleHandler.range = range;
    }

    @Override
    public void scheduleTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }
}

