/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.container.ItemAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.items.ItemImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAuraCache
extends ItemImpl
implements ITrinketItem {
    private final int capacity;

    public ItemAuraCache(String name, int capacity) {
        super(name);
        this.capacity = capacity;
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stackIn, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        EntityPlayer player;
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer && (player = (EntityPlayer)entityIn).func_70093_af()) {
            IAuraRecharge recharge;
            ItemStack stack;
            IAuraContainer container = (IAuraContainer)stackIn.getCapability(NaturesAuraAPI.capAuraContainer, null);
            if (container.getStoredAura() <= 0) {
                return;
            }
            for (int i = 0; !(i >= player.field_71071_by.func_70302_i_() || (stack = player.field_71071_by.func_70301_a(i)).hasCapability(NaturesAuraAPI.capAuraRecharge, null) && (recharge = (IAuraRecharge)stack.getCapability(NaturesAuraAPI.capAuraRecharge, null)).rechargeFromContainer(container, itemSlot, i, player.field_71071_by.field_70461_c == i)); ++i) {
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer, null);
            container.storeAura(container.getMaxAura(), false);
            items.add((Object)stack);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(NaturesAuraAPI.capAuraContainer, null)) {
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer, null);
            return 1.0 - (double)container.getStoredAura() / (double)container.getMaxAura();
        }
        return 0.0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilityProvider(){
            private final ItemAuraContainer container;
            {
                this.container = new ItemAuraContainer(stack, null, ItemAuraCache.this.capacity);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == NaturesAuraAPI.capAuraContainer;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == NaturesAuraAPI.capAuraContainer) {
                    return (T)this.container;
                }
                return null;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, EntityPlayer player, ITrinketItem.RenderType type, boolean isHolding) {
        if (type == ITrinketItem.RenderType.BODY && !isHolding) {
            boolean legs;
            boolean chest = !((ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.CHEST.func_188454_b())).func_190926_b();
            boolean bl = legs = !((ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.LEGS.func_188454_b())).func_190926_b();
            GlStateManager.func_179109_b((float)-0.15f, (float)0.65f, (float)(chest ? -0.195f : (legs ? -0.165f : -0.1475f)));
            GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Helper.renderItemInWorld(stack);
        }
    }
}

