/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenAncientTree
extends WorldGenAbstractTree {
    public WorldGenAncientTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height = rand.nextInt(3) + 5;
        BlockPos trunkTop = pos.func_177981_b(height);
        int rootsAmount = rand.nextInt(4) + 5;
        for (int i = 0; i < rootsAmount; ++i) {
            int length = rand.nextInt(3) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)rootsAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = pos.func_177963_a((double)x, 0.0, (double)z);
            while (!world.func_180495_p(goal).func_185913_b() && !((goal = goal.func_177977_b()).func_177951_i((Vec3i)pos) >= 100.0)) {
            }
            this.makeBranch(world, pos.func_177981_b(rand.nextInt(1)), goal, ModBlocks.ANCIENT_BARK.func_176223_P(), false);
        }
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                for (int i = height - (x + z) * (rand.nextInt(2) + 2); i >= 0; --i) {
                    BlockPos goal = pos.func_177982_a(x, i, z);
                    if (!this.isReplaceable(world, goal)) continue;
                    this.func_175903_a(world, goal, ModBlocks.ANCIENT_LOG.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                }
            }
        }
        this.makeLeaves(world, trunkTop.func_177981_b(rand.nextInt(2) - 1), ModBlocks.ANCIENT_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), rand.nextInt(2) + 3, rand);
        int branchAmount = rand.nextInt(3) + 4;
        for (int i = 0; i < branchAmount; ++i) {
            int length = rand.nextInt(2) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)branchAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = trunkTop.func_177963_a((double)x, (double)(rand.nextInt(3) + 1), (double)z);
            this.makeBranch(world, trunkTop, goal, ModBlocks.ANCIENT_LOG.func_176223_P(), true);
            this.makeLeaves(world, goal, ModBlocks.ANCIENT_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), rand.nextInt(2) + 2, rand);
        }
        return true;
    }

    protected boolean func_150523_a(Block blockType) {
        if (super.func_150523_a(blockType)) {
            return true;
        }
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151582_l || material == Material.field_151585_k;
    }

    private void makeBranch(World world, BlockPos first, BlockPos second, IBlockState state, boolean hasAxis) {
        BlockPos pos = second.func_177982_a(-first.func_177958_n(), -first.func_177956_o(), -first.func_177952_p());
        int length = this.getHighestCoord(pos);
        float stepX = (float)pos.func_177958_n() / (float)length;
        float stepY = (float)pos.func_177956_o() / (float)length;
        float stepZ = (float)pos.func_177952_p() / (float)length;
        for (int i = 0; i <= length; ++i) {
            BlockPos goal = first.func_177963_a((double)(0.5f + (float)i * stepX), (double)(0.5f + (float)i * stepY), (double)(0.5f + (float)i * stepZ));
            if (!this.isReplaceable(world, goal)) continue;
            if (hasAxis) {
                BlockLog.EnumAxis axis = this.getLogAxis(first, goal);
                this.func_175903_a(world, goal, state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
                continue;
            }
            this.func_175903_a(world, goal, state);
        }
    }

    private void makeLeaves(World world, BlockPos pos, IBlockState state, int radius, Random rand) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block;
                    BlockPos goal = pos.func_177982_a(x, y, z);
                    if (!(pos.func_177951_i((Vec3i)goal) <= (double)(radius * radius + rand.nextInt(3) - 1)) || !this.isReplaceable(world, goal) || (block = world.func_180495_p(goal).func_177230_c()) instanceof BlockLog || block == Blocks.field_150346_d || block == Blocks.field_150349_c) continue;
                    this.func_175903_a(world, goal, state);
                }
            }
        }
    }

    private int getHighestCoord(BlockPos pos) {
        return Math.max(MathHelper.func_76130_a((int)pos.func_177958_n()), Math.max(MathHelper.func_76130_a((int)pos.func_177956_o()), MathHelper.func_76130_a((int)pos.func_177952_p())));
    }

    private BlockLog.EnumAxis getLogAxis(BlockPos pos, BlockPos goal) {
        int y;
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.Y;
        int x = Math.abs(goal.func_177958_n() - pos.func_177958_n());
        int highest = Math.max(x, y = Math.abs(goal.func_177952_p() - pos.func_177952_p()));
        if (highest > 0) {
            if (x == highest) {
                axis = BlockLog.EnumAxis.X;
            } else if (y == highest) {
                axis = BlockLog.EnumAxis.Z;
            }
        }
        return axis;
    }
}

