/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SpreadEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "spread");

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        int moved;
        if (Math.abs(spot) < 1000000) {
            return;
        }
        boolean drain = spot > 0;
        for (int toMove = 720000; toMove > 0; toMove -= moved) {
            BlockPos bestOffset = null;
            int bestAmount = drain ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offset = pos.func_177967_a(facing, 15);
                if (!world.func_175667_e(offset) || offset.func_177956_o() < 0 || offset.func_177956_o() > world.func_72800_K()) continue;
                int amount = IAuraChunk.getAuraInArea(world, offset, 14);
                if (!(drain ? amount < bestAmount : amount > bestAmount)) continue;
                bestAmount = amount;
                bestOffset = offset;
            }
            if (bestOffset == null) break;
            BlockPos bestPos = drain ? IAuraChunk.getLowestSpot(world, bestOffset, 14, bestOffset) : IAuraChunk.getHighestSpot(world, bestOffset, 14, bestOffset);
            IAuraChunk bestChunk = IAuraChunk.getAuraChunk(world, bestPos);
            if (drain) {
                moved = bestChunk.storeAura(bestPos, 120000);
                auraChunk.drainAura(pos, moved);
                continue;
            }
            moved = bestChunk.drainAura(bestPos, 120000);
            auraChunk.storeAura(pos, moved);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return true;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

