/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityOfferingTable
extends TileEntityImpl
implements ITickable {
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 16;
        }
    };
    private final Queue<ItemStack> itemsToSpawn = new ArrayDeque<ItemStack>();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (!Multiblocks.OFFERING_TABLE.isComplete(this.field_145850_b, this.field_174879_c)) {
                    return;
                }
                ItemStack stack = this.items.getStackInSlot(0);
                if (stack.func_190926_b()) {
                    return;
                }
                List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0));
                if (items.isEmpty()) {
                    return;
                }
                OfferingRecipe recipe = TileEntityOfferingTable.getRecipe(stack);
                if (recipe == null) {
                    return;
                }
                for (EntityItem item : items) {
                    ItemStack itemStack;
                    if (item.field_70128_L || item.func_174874_s() || (itemStack = item.func_92059_d()).func_190926_b() || itemStack.func_190916_E() != 1 || !recipe.startItem.apply(itemStack)) continue;
                    int amount = Helper.getIngredientAmount(recipe.input);
                    int recipeCount = stack.func_190916_E() / amount;
                    stack.func_190918_g(recipeCount * amount);
                    item.func_70106_y();
                    this.sendToClients();
                    for (int i = 0; i < recipeCount; ++i) {
                        this.itemsToSpawn.add(recipe.output.func_77946_l());
                    }
                    this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
                    PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles((float)item.field_70165_t, (float)item.field_70163_u, (float)item.field_70161_v, 13, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                    break;
                }
            } else if (this.field_145850_b.func_82737_E() % 3L == 0L && !this.itemsToSpawn.isEmpty()) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), 256.0, (double)((float)this.field_174879_c.func_177952_p() + 0.5f), this.itemsToSpawn.remove()));
            }
        }
    }

    private static OfferingRecipe getRecipe(ItemStack input) {
        for (OfferingRecipe recipe : NaturesAuraAPI.OFFERING_RECIPES.values()) {
            if (!recipe.input.apply(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void writeNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_74782_a("items", (NBTBase)this.items.serializeNBT());
            if (type != TileEntityImpl.SaveType.SYNC) {
                NBTTagList list = new NBTTagList();
                for (ItemStack stack : this.itemsToSpawn) {
                    list.func_74742_a((NBTBase)stack.serializeNBT());
                }
                compound.func_74782_a("items_to_spawn", (NBTBase)list);
            }
        }
    }

    @Override
    public void readNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.func_74775_l("items"));
            if (type != TileEntityImpl.SaveType.SYNC) {
                this.itemsToSpawn.clear();
                NBTTagList list = compound.func_150295_c("items_to_spawn", 10);
                for (NBTBase base : list) {
                    this.itemsToSpawn.add(new ItemStack((NBTTagCompound)base));
                }
            }
        }
    }

    @Override
    public IItemHandlerModifiable getItemHandler(EnumFacing facing) {
        return this.items;
    }
}

