/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockImpl;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGoldPowder
extends BlockImpl
implements IColorProvidingBlock {
    public static final PropertyEnum<AttachPos> NORTH = PropertyEnum.func_177709_a((String)"north", AttachPos.class);
    public static final PropertyEnum<AttachPos> EAST = PropertyEnum.func_177709_a((String)"east", AttachPos.class);
    public static final PropertyEnum<AttachPos> SOUTH = PropertyEnum.func_177709_a((String)"south", AttachPos.class);
    public static final PropertyEnum<AttachPos> WEST = PropertyEnum.func_177709_a((String)"west", AttachPos.class);
    protected static final AxisAlignedBB[] AABBS = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0)};

    public BlockGoldPowder() {
        super("gold_powder", Material.field_151594_q);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(NORTH, (Comparable)((Object)AttachPos.NONE)).func_177226_a(EAST, (Comparable)((Object)AttachPos.NONE)).func_177226_a(SOUTH, (Comparable)((Object)AttachPos.NONE)).func_177226_a(WEST, (Comparable)((Object)AttachPos.NONE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockColor getBlockColor() {
        return (state, worldIn, pos, tintIndex) -> 16042818;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBS[BlockGoldPowder.getAABBIndex(state.func_185899_b(source, pos))];
    }

    private static int getAABBIndex(IBlockState state) {
        boolean w;
        int i = 0;
        boolean n = state.func_177229_b(NORTH) != AttachPos.NONE;
        boolean e = state.func_177229_b(EAST) != AttachPos.NONE;
        boolean s = state.func_177229_b(SOUTH) != AttachPos.NONE;
        boolean bl = w = state.func_177229_b(WEST) != AttachPos.NONE;
        if (n || s && !n && !e && !w) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (e || w && !n && !e && !s) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (s || n && !e && !s && !w) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (w || e && !n && !s && !w) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a(WEST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.WEST)));
        state = state.func_177226_a(EAST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.EAST)));
        state = state.func_177226_a(NORTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.NORTH)));
        state = state.func_177226_a(SOUTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.SOUTH)));
        return state;
    }

    private AttachPos getAttachPosition(IBlockAccess worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos dirPos = pos.func_177972_a(direction);
        IBlockState state = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (!(this.canConnectTo(worldIn.func_180495_p(dirPos), direction, worldIn, dirPos) || !state.func_185915_l() && this.canConnectUpwardsTo(worldIn, dirPos.func_177977_b()))) {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177984_a());
            if (!iblockstate1.func_185915_l()) {
                boolean flag;
                boolean bl = flag = worldIn.func_180495_p(dirPos).isSideSolid(worldIn, dirPos, EnumFacing.UP) || worldIn.func_180495_p(dirPos).func_177230_c() == Blocks.field_150426_aN;
                if (flag && this.canConnectUpwardsTo(worldIn, dirPos.func_177984_a())) {
                    if (state.func_185898_k()) {
                        return AttachPos.UP;
                    }
                    return AttachPos.SIDE;
                }
            }
            return AttachPos.NONE;
        }
        return AttachPos.SIDE;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return downState.func_185896_q() || downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return this.canConnectTo(worldIn.func_180495_p(pos), null, worldIn, pos);
    }

    private boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block == this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    private static enum AttachPos implements IStringSerializable
    {
        UP("up"),
        SIDE("side"),
        NONE("none");

        private final String name;

        private AttachPos(String name) {
            this.name = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

