/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityFieldCreator;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFieldCreator
extends BlockContainerImpl {
    public BlockFieldCreator() {
        super(Material.field_151576_e, "field_creator", TileEntityFieldCreator.class, "field_creator");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFieldCreator) {
            if (!worldIn.field_72995_K) {
                String key = "naturesaura:field_creator_pos";
                NBTTagCompound compound = playerIn.getEntityData();
                if (!playerIn.func_70093_af() && compound.func_74764_b(key)) {
                    BlockPos stored = BlockPos.func_177969_a((long)compound.func_74763_f(key));
                    TileEntityFieldCreator creator = (TileEntityFieldCreator)tile;
                    if (!pos.equals((Object)stored)) {
                        if (creator.isCloseEnough(stored)) {
                            TileEntity otherTile = worldIn.func_175625_s(stored);
                            if (otherTile instanceof TileEntityFieldCreator) {
                                creator.connectionOffset = stored.func_177973_b((Vec3i)pos);
                                creator.isMain = true;
                                creator.sendToClients();
                                TileEntityFieldCreator otherCreator = (TileEntityFieldCreator)otherTile;
                                otherCreator.connectionOffset = pos.func_177973_b((Vec3i)stored);
                                otherCreator.isMain = false;
                                otherCreator.sendToClients();
                                compound.func_82580_o(key);
                                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.connected", new Object[0]), true);
                            } else {
                                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.stored_pos_gone", new Object[0]), true);
                            }
                        } else {
                            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.too_far", new Object[0]), true);
                        }
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.same_position", new Object[0]), true);
                    }
                } else {
                    compound.func_74772_a(key, pos.func_177986_g());
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.stored_pos", new Object[0]), true);
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFieldCreator) {
            BlockPos connected;
            TileEntityFieldCreator creator = (TileEntityFieldCreator)tile;
            if (creator.isCharged && (connected = creator.getConnectedPos()) != null) {
                NaturesAuraAPI.instance().spawnParticleStream((float)pos.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, 0.65f, 4343284, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

