/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.reg.ICreativeItem;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.IModelProvider;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockContainerImpl
extends BlockContainer
implements IModItem,
ICreativeItem,
IModelProvider {
    private final String baseName;
    private final Class<? extends TileEntity> tileClass;
    private final String tileRegName;

    public BlockContainerImpl(Material material, String baseName, Class<? extends TileEntity> tileClass, String tileReg) {
        super(material);
        this.baseName = baseName;
        this.tileClass = tileClass;
        this.tileRegName = tileReg;
        ModRegistry.add(this);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        try {
            return this.tileClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(this.tileClass, (ResourceLocation)new ResourceLocation("naturesaura", this.tileRegName));
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityImpl) {
            ((TileEntityImpl)tile).dropInventory();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityImpl) {
            drops.add((Object)((TileEntityImpl)tile).getDrop(state, fortune));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityImpl) {
            ((TileEntityImpl)tile).loadDataOnPlace(stack);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateRedstoneState(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateRedstoneState(worldIn, pos);
    }

    private void updateRedstoneState(World world, BlockPos pos) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityImpl) {
            TileEntityImpl impl = (TileEntityImpl)tile;
            int newPower = world.func_175687_A(pos);
            if (impl.redstonePower != newPower) {
                world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            }
        }
    }

    public int func_149738_a(World worldIn) {
        return 4;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityImpl) {
            TileEntityImpl impl = (TileEntityImpl)tile;
            int newPower = worldIn.func_175687_A(pos);
            if (impl.redstonePower != newPower) {
                impl.onRedstonePowerChange(newPower);
            }
        }
    }
}

