/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityChunkLoader;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChunkLoader
extends BlockContainerImpl
implements IVisualizable {
    private static final AxisAlignedBB BOUND_BOX = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);

    public BlockChunkLoader() {
        super(Material.field_151576_e, "chunk_loader", TileEntityChunkLoader.class, "chunk_loader");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        super.onInit(event);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)NaturesAura.instance, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        int range;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityChunkLoader && (range = ((TileEntityChunkLoader)tile).range()) > 0) {
            return new AxisAlignedBB((double)(pos.func_177958_n() - range >> 4 << 4), 0.0, (double)(pos.func_177952_p() - range >> 4 << 4), (double)((pos.func_177958_n() + range >> 4 << 4) + 16), (double)world.func_72800_K(), (double)((pos.func_177952_p() + range >> 4 << 4) + 16));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityChunkLoader) {
            int range = ((TileEntityChunkLoader)tile).range();
            for (int i = MathHelper.func_76123_f((float)((float)range / 8.0f)); i > 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + worldIn.field_73012_v.nextFloat(), (float)pos.func_177956_o() + worldIn.field_73012_v.nextFloat(), (float)pos.func_177952_p() + worldIn.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, 10563071, 1.0f + worldIn.field_73012_v.nextFloat(), 100, 0.0f, false, true);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 12671481;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUND_BOX;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class ChunkLoadingCallback
    implements ForgeChunkManager.LoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                NBTTagCompound data = ticket.getModData();
                BlockPos pos = BlockPos.func_177969_a((long)data.func_74763_f("pos"));
                TileEntity tile = world.func_175625_s(pos);
                if (!(tile instanceof TileEntityChunkLoader)) continue;
                TileEntityChunkLoader loader = (TileEntityChunkLoader)tile;
                loader.updateTicket(ticket);
                loader.loadChunks();
            }
        }
    }
}

