/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityAnimalGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAnimalGenerator
extends BlockContainerImpl
implements IVisualizable {
    public BlockAnimalGenerator() {
        super(Material.field_151576_e, "animal_generator", TileEntityAnimalGenerator.class, "animal_generator");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !(entity instanceof IAnimals) || entity instanceof IMob || entity instanceof INpc) {
            return;
        }
        NBTTagCompound data = entity.getEntityData();
        int timeAlive = data.func_74762_e("naturesaura:time_alive");
        data.func_74768_a("naturesaura:time_alive", timeAlive + 1);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !(entity instanceof IAnimals) || entity instanceof IMob || entity instanceof INpc) {
            return;
        }
        BlockPos pos = entity.func_180425_c();
        Helper.getTileEntitiesInArea(entity.field_70170_p, pos, 5, tile -> {
            if (!(tile instanceof TileEntityAnimalGenerator)) {
                return false;
            }
            TileEntityAnimalGenerator gen = (TileEntityAnimalGenerator)((Object)tile);
            NBTTagCompound data = entity.getEntityData();
            data.func_74757_a("naturesaura:no_drops", true);
            if (gen.isBusy()) {
                return false;
            }
            boolean child = entity.func_70631_g_();
            float timeMod = child ? 0.5f : 1.0f;
            float amountMod = child ? 0.667f : 1.0f;
            int timeAlive = data.func_74762_e("naturesaura:time_alive");
            int time = Math.min(MathHelper.func_76141_d((float)((float)(timeAlive - 15000) / 500.0f * timeMod)), 200);
            int amount = Math.min(MathHelper.func_76141_d((float)((float)(timeAlive - 8000) / 2.0f * amountMod)), 25000);
            if (time <= 0 || amount <= 0) {
                return false;
            }
            gen.setGenerationValues(time, amount);
            BlockPos genPos = gen.func_174877_v();
            PacketHandler.sendToAllAround(entity.field_70170_p, pos, 32, new PacketParticles((float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, 17, child ? 1 : 0, (int)(entity.func_70047_e() * 10.0f), genPos.func_177958_n(), genPos.func_177956_o(), genPos.func_177952_p()));
            return true;
        });
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.getEntityData().func_74767_n("naturesaura:no_drops")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityExp(LivingExperienceDropEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.getEntityData().func_74767_n("naturesaura:no_drops")) {
            event.setCanceled(true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        return new AxisAlignedBB(pos).func_186662_g(5.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 1128314;
    }
}

