/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.BasicAuraType;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.recipes.WeightedOre;
import de.ellpeck.naturesaura.chunk.effect.OreSpawnEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.config.Config;

@Config(modid="naturesaura", category="")
public final class ModConfig {
    public static General general = new General();
    public static Features enabledFeatures = new Features();
    public static Client client = new Client();

    public static void initOrReload(boolean reload) {
        if (!reload) {
            String[] split;
            try {
                for (String s : ModConfig.general.additionalBotanistPickaxeConversions) {
                    split = s.split("->");
                    NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Helper.getStateFromString(split[0]), (Object)Helper.getStateFromString(split[1]));
                }
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Error parsing additionalBotanistPickaxeConversions", (Throwable)e);
            }
            try {
                for (String s : ModConfig.general.additionalFlowers) {
                    NaturesAuraAPI.FLOWERS.add(Helper.getStateFromString(s));
                }
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Error parsing additionalFlowers", (Throwable)e);
            }
            try {
                for (String s : ModConfig.general.auraTypeOverrides) {
                    split = s.split("->");
                    IAuraType type = NaturesAuraAPI.AURA_TYPES.get(new ResourceLocation(split[1]));
                    if (!(type instanceof BasicAuraType)) continue;
                    ((BasicAuraType)type).addDimensionType(DimensionType.func_193417_a((String)split[0]));
                }
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Error parsing auraTypeOverrides", (Throwable)e);
            }
            try {
                for (String s : ModConfig.general.additionalOres) {
                    split = s.split(":");
                    WeightedOre ore = new WeightedOre(split[0], Integer.parseInt(split[1]));
                    String dimension = split[2];
                    if ("nether".equalsIgnoreCase(dimension)) {
                        NaturesAuraAPI.NETHER_ORES.add(ore);
                        continue;
                    }
                    NaturesAuraAPI.OVERWORLD_ORES.add(ore);
                }
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Error parsing additionalOres", (Throwable)e);
            }
            try {
                for (String s : ModConfig.general.oreExceptions) {
                    OreSpawnEffect.SPAWN_EXCEPTIONS.add(Helper.getStateFromString(s));
                }
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Error parsing oreExceptions", (Throwable)e);
            }
            try {
                for (String s : ModConfig.general.additionalProjectiles) {
                    split = s.split("->");
                    ResourceLocation name = new ResourceLocation(split[0]);
                    int amount = Integer.parseInt(split[1]);
                    NaturesAuraAPI.PROJECTILE_GENERATIONS.put(name, amount);
                }
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Error parsing additionalProjectiles", (Throwable)e);
            }
        }
    }

    public static class Client {
        @Config.Comment(value={"The percentage of particles that should be displayed, where 1 is 100% and 0 is 0%"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double particleAmount = 1.0;
        @Config.Comment(value={"If particle spawning should respect the particle setting in Minecraft's video settings screen"})
        public boolean respectVanillaParticleSettings = true;
        @Config.Comment(value={"The percentage of particles that should spawn when there is an excess amount of Aura in the environment, where 1 is 100% and 0 is 0%"})
        public double excessParticleAmount = 1.0;
        @Config.Comment(value={"The location of the aura bar, where 0 is top left, 1 is top right, 2 is bottom left and 3 is bottom right"})
        @Config.RangeInt(min=0, max=3)
        public int auraBarLocation = 0;
        @Config.Comment(value={"If debug information about Aura around the player should be displayed in the F3 debug menu if the player is in creative mode"})
        public boolean debugText = true;
        @Config.Comment(value={"If, when the F3 debug menu is open and the player is in creative mode, every Aura spot should be highlighted in the world for debug purposes"})
        public boolean debugWorld = false;
    }

    public static class Features {
        @Config.Comment(value={"If using Dragon's Breath in a Brewing Stand should not cause a glass bottle to appear"})
        public boolean removeDragonBreathContainerItem = true;
        @Config.Comment(value={"If the RF converter block should be enabled"})
        public boolean rfConverter = true;
        @Config.Comment(value={"If the chunk loader block should be enabled"})
        public boolean chunkLoader = true;
        @Config.Comment(value={"If the Aura Imbalance effect of grass and trees dying in the area if the Aura levels are too low should occur"})
        public boolean grassDieEffect = true;
        @Config.Comment(value={"If the Aura Imbalance effect of plant growth being boosted if the Aura levels are high enough should occur"})
        public boolean plantBoostEffect = true;
        @Config.Comment(value={"If the Aura Imbalance effect of aura containers in players' inventories being filled if the Aura levels are high enough should occur"})
        public boolean cacheRechargeEffect = true;
        @Config.Comment(value={"If the Aura Imbalance effect of explosions happening randomly if Aura levels are too low should occur"})
        public boolean explosionEffect = true;
        @Config.Comment(value={"If the Aura Imbalance effect of breathlessness if Aura levels are too low should occur"})
        public boolean breathlessEffect = true;
        @Config.Comment(value={"If the Aura Imbalance effect of farm animals being affected in positive ways if Aura levels are too high should occur"})
        public boolean animalEffect = true;
        @Config.Comment(value={"If the Aura Imbalance effect of ores spawning in the area if Aura levels are too high should occur"})
        public boolean oreEffect = true;
    }

    public static class General {
        @Config.Comment(value={"Additional conversion recipes for the Botanist's Pickaxe right click function. Each entry needs to be formatted as modid:input_block[prop1=value1,...]->modid:output_block[prop1=value1,...] where block state properties are optional"})
        public String[] additionalBotanistPickaxeConversions = new String[0];
        @Config.Comment(value={"Additional blocks that several mechanics identify as flowers. Each entry needs to be formatted as modid:block[prop1=value1,...] where block state properties are optional"})
        public String[] additionalFlowers = new String[0];
        @Config.Comment(value={"Additional dimensions that map to Aura types that should be present in them. This is useful if you have a modpack with custom dimensions that should have Aura act similarly to an existing dimension in them. Each entry needs to be formatted as dimension_name->aura_type, where aura_type can be any of naturesaura:overworld, naturesaura:nether and naturesaura:end."})
        public String[] auraTypeOverrides = new String[0];
        @Config.Comment(value={"Additional blocks that are recognized as generatable ores for the passive ore generation effect. Each entry needs to be formatted as oredictEntry:oreWeight:dimension where a higher weight makes the ore more likely to spawn with 5000 being the weight of coal, the default ore with the highest weight, and dimension being any of overworld and nether"})
        public String[] additionalOres = new String[0];
        @Config.Comment(value={"Blocks that are exempt from being recognized as generatable ores for the passive ore generation effect. Each entry needs to be formatted as modid:block[prop1=value1,...] where block state properties are optional"})
        public String[] oreExceptions = new String[0];
        @Config.Comment(value={"Additional projectile types that are allowed to be consumed by the projectile generator. Each entry needs to be formatted as entity_registry_name->aura_amount"})
        public String[] additionalProjectiles = new String[0];
        @Config.Comment(value={"The amount of blocks that can be between two Aura Field Creators for them to be connectable and work together"})
        public int fieldCreatorRange = 10;
        @Config.Comment(value={"The Aura to RF ratio used by the RF converter, read as aura*ratio = rf"})
        public float auraToRFRatio = 0.05f;
    }
}

