/*
 * Decompiled with CFR 0.152.
 */
package me.illgilp.packmodemenu.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public final class ConfigScreen
extends GuiScreen {
    private GuiButtonExt switchBtn;
    private GuiButtonExt saveBtn;
    private String mode = "";
    private String defaultMode = "";
    private Property acceptedModes;
    private Property packMode;
    private Configuration configuration;
    private GuiScreen lastScreen;
    private boolean firstInit = true;

    public ConfigScreen(GuiScreen lastScreen) {
        this.lastScreen = lastScreen;
        this.configuration = new Configuration(new File("config/packmode.cfg"));
        this.configuration.load();
        this.packMode = this.configuration.get("general", "packMode", "normal");
        this.acceptedModes = this.configuration.get("general", "acceptedModes", new String[]{"normal", "expert"});
    }

    public void func_73866_w_() {
        if (this.firstInit) {
            this.mode = this.packMode.getString();
            this.defaultMode = this.packMode.getString();
        }
        this.switchBtn = new GuiButtonExt(0, this.field_146294_l / 2 - 100, this.field_146295_m / 6, this.getButtonText());
        this.field_146292_n.add(this.switchBtn);
        this.saveBtn = new GuiButtonExt(1, this.field_146294_l / 2 - 155, this.field_146295_m - 50, 150, 20, I18n.func_135052_a((String)"packmodemenu.options.save", (Object[])new Object[0]));
        this.saveBtn.field_146124_l = !this.mode.equals(this.defaultMode);
        this.field_146292_n.add(this.saveBtn);
        this.field_146292_n.add(new GuiButtonExt(2, this.field_146294_l / 2 + 5, this.field_146295_m - 50, 150, 20, I18n.func_135052_a((String)"packmodemenu.options.cancel", (Object[])new Object[0])));
        super.func_73866_w_();
        this.firstInit = false;
    }

    private String getButtonText() {
        String translatedModeName = I18n.func_188566_a((String)("packmodemenu.packmode.name." + this.mode)) ? I18n.func_135052_a((String)("packmodemenu.packmode.name." + this.mode), (Object[])new Object[0]) : this.mode.toUpperCase();
        return I18n.func_135052_a((String)"packmodemenu.options.pack_mode", (Object[])new Object[0]) + ": " + (!this.mode.equals(this.defaultMode) ? "\u00a7a" : "") + translatedModeName + (!this.mode.equals(this.defaultMode) ? "" : " (" + I18n.func_135052_a((String)"packmodemenu.options.current", (Object[])new Object[0]) + ")");
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"packmodemenu.options.pack_mode", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        StringBuilder textMultiline = new StringBuilder();
        if (I18n.func_188566_a((String)("packmodemenu.packmode.desc." + this.mode))) {
            textMultiline.append(I18n.func_135052_a((String)("packmodemenu.packmode.desc." + this.mode), (Object[])new Object[0]).replace("\\n", "\n")).append("\n\n");
        }
        if (!this.mode.equals(this.defaultMode)) {
            String[] warningText;
            for (String line : warningText = I18n.func_135052_a((String)"packmodemenu.options.warning.restart", (Object[])new Object[0]).split("\\\\n")) {
                textMultiline.append(ChatFormatting.RED).append(line).append("\n");
            }
        }
        this.drawMultilineString(textMultiline.toString(), this.field_146294_l / 2, this.field_146295_m / 6 + 40 - 6, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.switchBtn.field_146127_k) {
            this.mode = this.acceptedModes.getStringList()[(new ArrayList<String>(Arrays.asList(this.acceptedModes.getStringList())).lastIndexOf(this.mode) + 1) % this.acceptedModes.getStringList().length];
            this.switchBtn.field_146126_j = this.getButtonText();
            this.saveBtn.field_146124_l = !this.mode.equals(this.defaultMode);
        } else if (button.field_146127_k == this.saveBtn.field_146127_k) {
            this.packMode.set(this.mode);
            this.configuration.save();
            Minecraft.func_71410_x().func_147108_a(this.lastScreen);
        } else {
            Minecraft.func_71410_x().func_147108_a(this.lastScreen);
        }
    }

    public void drawMultilineString(String textMultiline, int x, int y, int color) {
        String[] texts = textMultiline.split("\\n");
        int offset = 0;
        for (String text : texts) {
            this.func_73732_a(this.field_146289_q, text, x, y + offset, color);
            offset += 10;
        }
    }
}

