/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.item.IUpgradeItem;
import cofh.core.block.TilePowered;
import cofh.core.gui.container.ContainerTileAugmentable;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.impl.EnergyStorage;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.storage.BlockCell;
import cofh.thermalexpansion.gui.client.storage.GuiCell;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCell
extends TilePowered
implements ITickable,
IEnergyProvider {
    public static final int CAPACITY_BASE = 2000000;
    public static final int XFER_BASE = 1000;
    public static final int[] XFER_SCALE = new int[]{1, 4, 9, 16, 25};
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final byte[] DEFAULT_SIDES = new byte[]{2, 1, 1, 1, 1, 1};
    public static final byte[] CREATIVE_SIDES = new byte[]{2, 2, 2, 2, 2, 2};
    public static final int[] RECV = new int[]{1, 4, 9, 16, 25};
    public static final int[] SEND = new int[]{1, 4, 9, 16, 25};
    private int compareTracker;
    private int meterTracker;
    private int outputTracker;
    public short enchantHolding;
    public int amountRecv;
    public int amountSend;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCell.class, (String)"thermalexpansion:storage_cell");
        TileCell.config();
    }

    public static void config() {
        String category = "Storage.Cell";
        String comment = "If TRUE, Energy Cells are enabled.";
        BlockCell.enable = ThermalExpansion.CONFIG.get(category, "Enable", BlockCell.enable, comment);
        comment = "If TRUE, Energy Cells may be turned into Creative versions using a Creative Conversion Kit.";
        BlockCell.enableCreative = ThermalExpansion.CONFIG.get(category, "Creative", BlockCell.enableCreative, comment);
        comment = "If TRUE, Energy Cells are securable.";
        BlockCell.enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", BlockCell.enableSecurity, comment);
        comment = "If TRUE, 'Classic' Crafting is enabled - Non-Creative Upgrade Kits WILL NOT WORK in a Crafting Grid.";
        BlockCell.enableClassicRecipes = ThermalExpansion.CONFIG.get(category, "ClassicCrafting", BlockCell.enableClassicRecipes, comment);
        comment = "If TRUE, Energy Cells can be upgraded in a Crafting Grid using Kits. If Classic Crafting is enabled, only the Creative Conversion Kit may be used in this fashion.";
        BlockCell.enableUpgradeKitCrafting = ThermalExpansion.CONFIG.get(category, "UpgradeKitCrafting", BlockCell.enableUpgradeKitCrafting, comment);
        int capacity = 2000000;
        comment = "Adjust this value to change the amount of Energy (in RF) stored by a Basic Cell. This base value will scale with block level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, 50000, capacity * 10, comment);
        int recv = 1000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be received by a Basic Cell. This base value will scale with block level.";
        recv = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseReceive", category, recv, recv / 10, recv * 10, comment);
        int send = 1000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be sent by a Basic Cell. This base value will scale with block level.";
        send = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseSend", category, send, send / 10, send * 10, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * capacity;
            int n2 = i;
            RECV[n2] = RECV[n2] * recv;
            int n3 = i++;
            SEND[n3] = SEND[n3] * send;
        }
    }

    public TileCell() {
        this.energyStorage = new EnergyStorage(TileCell.getMaxCapacity(0, 0));
        this.setDefaultSides();
        this.enableAutoOutput = true;
    }

    protected Object getMod() {
        return ThermalExpansion.instance;
    }

    protected String getModVersion() {
        return "5.5.7";
    }

    protected String getTileName() {
        return "tile.thermalexpansion.storage.cell.name";
    }

    protected int getLevelRSControl() {
        return TEProps.levelRedstoneControl;
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    public int getLightValue() {
        return MathHelper.clamp((int)(this.energyStorage.getEnergyStored() > 0 ? 1 + this.getScaledEnergyStored(8) : 0), (int)0, (int)8);
    }

    public byte[] getDefaultSides() {
        return (byte[])DEFAULT_SIDES.clone();
    }

    public boolean enableSecurity() {
        return BlockCell.enableSecurity;
    }

    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return !BlockCell.enableClassicRecipes;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return !BlockCell.enableClassicRecipes;
            }
            case CREATIVE: {
                return !this.isCreative && BlockCell.enableCreative;
            }
        }
        return false;
    }

    public boolean installUpgrade(ItemStack upgrade) {
        boolean isCreative = this.isCreative;
        boolean installUpgrade = super.installUpgrade(upgrade);
        if (installUpgrade && !isCreative && this.isCreative) {
            for (int i = 0; i < 6; ++i) {
                this.sideCache[i] = 2;
            }
            this.sendTilePacket(Side.CLIENT);
            this.callNeighborTileChange();
        }
        return installUpgrade;
    }

    protected boolean setLevel(int level) {
        byte curLevel = this.level;
        if (super.setLevel(level)) {
            this.energyStorage.setCapacity(TileCell.getMaxCapacity(level, this.enchantHolding));
            this.amountRecv = this.amountRecv * XFER_SCALE[level] / XFER_SCALE[curLevel];
            this.amountSend = this.amountSend * XFER_SCALE[level] / XFER_SCALE[curLevel];
            if (this.isCreative) {
                this.energyStorage.setEnergyStored(this.energyStorage.getMaxEnergyStored());
            }
            if (this.field_145850_b != null) {
                this.updateTrackers();
            }
            return true;
        }
        return false;
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        this.amountRecv = tag.func_74762_e("Recv") * XFER_SCALE[this.level] / 1000;
        this.amountSend = tag.func_74762_e("Send") * XFER_SCALE[this.level] / 1000;
        return super.readPortableTagInternal(player, tag);
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        tag.func_74768_a("Recv", this.amountRecv * 1000 / XFER_SCALE[this.level]);
        tag.func_74768_a("Send", this.amountSend * 1000 / XFER_SCALE[this.level]);
        return super.writePortableTagInternal(player, tag);
    }

    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public void func_73660_a() {
        if (this.redstoneControlOrDisable()) {
            this.transferEnergy();
        }
        if (this.timeCheck()) {
            this.updateTrackers();
        }
    }

    public static int getMaxCapacity(int level, int enchant) {
        return (int)Math.max((double)CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] + (double)CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] * (double)enchant / 2.0, 0.0);
    }

    public int getScaledEnergyStored(int scale) {
        return MathHelper.round((double)((long)this.energyStorage.getEnergyStored() * (long)scale / (long)TileCell.getMaxCapacity(this.level, this.enchantHolding)));
    }

    protected void transferEnergy() {
        int i;
        for (i = this.outputTracker; i < 6 && this.energyStorage.getEnergyStored() > 0; ++i) {
            if (this.sideCache[i] != 2) continue;
            if (this.isCreative) {
                EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)this.amountSend, (boolean)false);
                continue;
            }
            this.energyStorage.modifyEnergyStored(-EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)Math.min(this.amountSend, this.energyStorage.getEnergyStored()), (boolean)false));
        }
        for (i = 0; i < this.outputTracker && this.energyStorage.getEnergyStored() > 0; ++i) {
            if (this.sideCache[i] != 2) continue;
            if (this.isCreative) {
                EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)this.amountSend, (boolean)false);
                continue;
            }
            this.energyStorage.modifyEnergyStored(-EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)Math.min(this.amountSend, this.energyStorage.getEnergyStored()), (boolean)false));
        }
        ++this.outputTracker;
        this.outputTracker %= 6;
    }

    protected void updateTrackers() {
        int curScale;
        int n = curScale = this.energyStorage.getEnergyStored() > 0 ? 1 + this.getScaledEnergyStored(14) : 0;
        if (curScale != this.compareTracker) {
            this.compareTracker = curScale;
            this.callNeighborTileChange();
        }
        int n2 = curScale = this.energyStorage.getEnergyStored() > 0 ? 1 + Math.min(this.getScaledEnergyStored(8), 7) : 0;
        if (this.meterTracker != curScale) {
            this.meterTracker = curScale;
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCell(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTileAugmentable(inventory, (TileEntity)this);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74765_d("EncHolding");
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74771_c("Tracker");
        this.amountRecv = nbt.func_74762_e("Recv");
        this.amountSend = nbt.func_74762_e("Send");
        this.energyStorage = new EnergyStorage(TileCell.getMaxCapacity(this.level, this.enchantHolding));
        this.energyStorage.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("EncHolding", this.enchantHolding);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("Recv", this.amountRecv);
        nbt.func_74768_a("Send", this.amountSend);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addInt(MathHelper.clamp((int)this.amountRecv, (int)0, (int)RECV[this.level]));
        payload.addInt(MathHelper.clamp((int)this.amountSend, (int)0, (int)SEND[this.level]));
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.amountRecv = payload.getInt();
        this.amountSend = payload.getInt();
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.amountRecv);
        payload.addInt(this.amountSend);
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addShort(this.enchantHolding);
        payload.addInt(this.amountRecv);
        payload.addInt(this.amountSend);
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.amountRecv = payload.getInt();
        this.amountSend = payload.getInt();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.enchantHolding = payload.getShort();
        this.amountRecv = payload.getInt();
        this.amountSend = payload.getInt();
        this.callBlockUpdate();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (from == null || this.sideCache[from.ordinal()] == 2) {
            if (this.isCreative) {
                return maxExtract;
            }
            return this.energyStorage.extractEnergy(Math.min(maxExtract, this.amountSend), simulate);
        }
        return 0;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (from == null || this.sideCache[from.ordinal()] == 1) {
            if (this.isCreative) {
                return maxReceive;
            }
            return this.energyStorage.receiveEnergy(Math.min(maxReceive, this.amountRecv), simulate);
        }
        return 0;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.isCreative ? this.energyStorage.getMaxEnergyStored() : this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public final boolean decrSide(int side) {
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + (this.getNumConfig(side) - 1));
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendConfigPacket();
        return true;
    }

    public final boolean incrSide(int side) {
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + 1);
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendConfigPacket();
        return true;
    }

    public boolean setSide(int side, int config) {
        if (this.sideCache[side] == config || config >= this.getNumConfig(side)) {
            return false;
        }
        this.sideCache[side] = (byte)config;
        this.sendConfigPacket();
        return true;
    }

    public int getNumConfig(int side) {
        return 3;
    }

    public int[] func_180463_a(EnumFacing side) {
        return CoreProps.EMPTY_INVENTORY;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    public int getNumPasses() {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            return TETextures.CELL_CENTER_1;
        }
        if (pass == 1) {
            return this.isCreative ? TETextures.CELL_SIDE_C : TETextures.CELL_SIDE[this.level];
        }
        if (pass == 2) {
            return TETextures.CELL_CONFIG[this.sideCache[side]];
        }
        if (side != this.facing) {
            return TETextures.CONFIG_NONE;
        }
        return this.isCreative ? TETextures.CELL_METER_C : TETextures.CELL_METER[MathHelper.clamp((int)(this.energyStorage.getEnergyStored() > 0 ? 1 + this.getScaledEnergyStored(8) : 0), (int)0, (int)8)];
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, from));
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return TileCell.this.receiveEnergy(from, maxReceive, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return TileCell.this.extractEnergy(from, maxExtract, simulate);
                }

                public int getEnergyStored() {
                    return TileCell.this.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return TileCell.this.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return true;
                }

                public boolean canReceive() {
                    return true;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

