/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class RegistryHelper {
    public static Block getBlock(String location) {
        ResourceLocation resLoc = new ResourceLocation(location);
        if (!Loader.isModLoaded((String)resLoc.func_110624_b())) {
            return null;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(resLoc);
    }

    public static Item getItem(String location) {
        ResourceLocation resLoc = new ResourceLocation(location);
        if (!Loader.isModLoaded((String)resLoc.func_110624_b())) {
            return null;
        }
        return (Item)ForgeRegistries.ITEMS.getValue(resLoc);
    }

    public static ItemStack blockStackFromRegistry(String location, int stackSize) {
        Block block = RegistryHelper.getBlock(RegistryHelper.removeMeta(location));
        return block == null ? null : new ItemStack(block, stackSize, RegistryHelper.getMeta(location));
    }

    public static ItemStack blockStackFromRegistry(String location) {
        return RegistryHelper.blockStackFromRegistry(location, 1);
    }

    public static ItemStack itemStackFromRegistry(String location, int stackSize) {
        Item item = RegistryHelper.getItem(RegistryHelper.removeMeta(location));
        return item == null ? null : new ItemStack(item, stackSize, RegistryHelper.getMeta(location));
    }

    public static ItemStack itemStackFromRegistry(String location) {
        return RegistryHelper.itemStackFromRegistry(location, 1);
    }

    public static IBlockState blockStateFromRegistry(String location) {
        Block block = RegistryHelper.getBlock(RegistryHelper.removeMeta(location));
        return block == null ? null : block.func_176203_a(RegistryHelper.getMeta(location));
    }

    public static Biome biomeFromRegistry(String location) {
        ResourceLocation resLoc = new ResourceLocation(location);
        if (!Loader.isModLoaded((String)resLoc.func_110624_b())) {
            return null;
        }
        return (Biome)ForgeRegistries.BIOMES.getValue(resLoc);
    }

    public static int getMeta(String location) {
        if (StringUtils.countMatches((CharSequence)location, (char)':') < 2) {
            return 0;
        }
        return Integer.parseInt(location.substring(location.lastIndexOf(58) + 1));
    }

    public static String removeMeta(String location) {
        if (StringUtils.countMatches((CharSequence)location, (char)':') < 2) {
            return location;
        }
        return StringHelper.starting(location, location.lastIndexOf(58));
    }

    public static String getModID(ItemStack stack) {
        if (stack == null) {
            return "";
        }
        Item item = stack.func_77973_b();
        if (item == null || item.delegate == null || item.delegate.name() == null || item.delegate.name().func_110624_b() == null) {
            return "";
        }
        return item.delegate.name().func_110624_b();
    }
}

