/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import nc.config.NCConfig;

public interface IUpgradable {
    public boolean hasUpgrades();

    public int getSpeedCount();

    public int getEnergyCount();

    public int getSpeedUpgradeSlot();

    public int getEnergyUpgradeSlot();

    default public double getSpeedMultiplier() {
        return 1.0 + NCConfig.speed_upgrade_multipliers[0] * this.powerLawFactor(this.getSpeedCount(), NCConfig.speed_upgrade_power_laws[0]);
    }

    default public double getPowerMultiplier() {
        return (1.0 + NCConfig.speed_upgrade_multipliers[1] * this.powerLawFactor(this.getSpeedCount(), NCConfig.speed_upgrade_power_laws[1])) / (1.0 + NCConfig.energy_upgrade_multipliers[0] * this.powerLawFactor(this.getEnergyCount(), NCConfig.energy_upgrade_power_laws[0]));
    }

    default public double powerLawFactor(int upgradeCount, double power) {
        return Math.pow(upgradeCount, power) - 1.0;
    }

    public void refreshUpgrades();
}

