/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import nc.recipe.ProcessorRecipeHandler;

public class IsotopeSeparatorRecipes
extends ProcessorRecipeHandler {
    public IsotopeSeparatorRecipes() {
        super("isotope_separator", 1, 0, 2, 0);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotThorium", "dustThorium"}), "ingotThorium232", "nuggetThorium230", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotThoriumOxide", "dustThoriumOxide"}), "ingotThorium232Oxide", "nuggetThorium230Oxide", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotUranium", "dustUranium", "ingotYellorium", "dustYellorium"}), "ingotUranium238Base", "nuggetUranium235", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotUraniumOxide", "dustUraniumOxide"}), "ingotUranium238Oxide", "nuggetUranium235Oxide", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotBlutonium", "dustBlutonium", "ingotPlutonium", "dustPlutonium"}), "ingotPlutonium239Base", "nuggetPlutonium242", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotPlutoniumOxide", "dustPlutoniumOxide"}), "ingotPlutonium239Oxide", "nuggetPlutonium242Oxide", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotBoron", "dustBoron"}), "ingotBoron11", IsotopeSeparatorRecipes.oreStack("nuggetBoron10", 3), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotLithium", "dustLithium"}), "ingotLithium7", IsotopeSeparatorRecipes.oreStack("nuggetLithium6", 3), 1.0, 1.0);
        this.addRecipe("fuelTBU", IsotopeSeparatorRecipes.oreStack("ingotThorium232", 9), IsotopeSeparatorRecipes.emptyItemStack(), 1.0, 1.0);
        this.addRecipe("fuelTBUOxide", IsotopeSeparatorRecipes.oreStack("ingotThorium232Oxide", 9), IsotopeSeparatorRecipes.emptyItemStack(), 1.0, 1.0);
        this.addRecipe("fuelRodTBU", IsotopeSeparatorRecipes.oreStack("ingotThorium232", 9), IsotopeSeparatorRecipes.emptyItemStack(), 1.0, 1.0);
        this.addRecipe("fuelRodTBUOxide", IsotopeSeparatorRecipes.oreStack("ingotThorium232Oxide", 9), IsotopeSeparatorRecipes.emptyItemStack(), 1.0, 1.0);
        this.addRecipe("fuelMOX239", IsotopeSeparatorRecipes.oreStack("ingotUranium238Base", 8), IsotopeSeparatorRecipes.oreStack("ingotPlutonium239Oxide", 1), 1.0, 1.0);
        this.addRecipe("fuelMOX241", IsotopeSeparatorRecipes.oreStack("ingotUranium238Base", 8), IsotopeSeparatorRecipes.oreStack("ingotPlutonium241Oxide", 1), 1.0, 1.0);
        this.addRecipe("fuelRodMOX239", IsotopeSeparatorRecipes.oreStack("ingotUranium238Base", 8), IsotopeSeparatorRecipes.oreStack("ingotPlutonium239Oxide", 1), 1.0, 1.0);
        this.addRecipe("fuelRodMOX241", IsotopeSeparatorRecipes.oreStack("ingotUranium238Base", 8), IsotopeSeparatorRecipes.oreStack("ingotPlutonium241Oxide", 1), 1.0, 1.0);
        this.addFuelSeparationRecipes("U", "Uranium", 238, 233, 235);
        this.addFuelSeparationRecipes("N", "Neptunium", 237, 236);
        this.addFuelSeparationRecipes("P", "Plutonium", 242, 239, 241);
        this.addFuelSeparationRecipes("A", "Americium", 243, 242);
        this.addFuelSeparationRecipes("Cm", "Curium", 246, 243, 245, 247);
        this.addFuelSeparationRecipes("B", "Berkelium", 247, 248);
        this.addFuelSeparationRecipes("Cf", "Californium", 252, 249, 251);
    }

    public void addFuelSeparationRecipes(String fuel, String element, int fertile, int ... fissiles) {
        for (String form : new String[]{"fuel", "fuelRod"}) {
            for (int fissile : fissiles) {
                for (String type : new String[]{"LE", "HE"}) {
                    for (String oxide : new String[]{"", "Oxide"}) {
                        this.addRecipe(form + type + fuel + fissile + oxide, IsotopeSeparatorRecipes.oreStack("ingot" + element + fertile + (oxide.equals("") ? "Base" : ""), type.equals("LE") ? 8 : 5), IsotopeSeparatorRecipes.oreStack("ingot" + element + fissile + oxide, type.equals("LE") ? 1 : 4), 1.0, 1.0);
                    }
                }
            }
        }
    }
}

