/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nc.config.NCConfig;
import nc.util.RegistryHelper;
import net.minecraft.world.biome.Biome;

public class RadBiomes {
    public static final Map<Biome, Double> RAD_MAP = new HashMap<Biome, Double>();
    public static final Map<Biome, Double> LIMIT_MAP = new HashMap<Biome, Double>();
    public static final Set<Integer> DIM_BLACKLIST = new ObjectOpenHashSet();

    public static void init() {
        Biome biome;
        int scorePos;
        for (String biomeInfo : NCConfig.radiation_biomes) {
            scorePos = biomeInfo.lastIndexOf(95);
            if (scorePos == -1 || (biome = RegistryHelper.biomeFromRegistry(biomeInfo.substring(0, scorePos))) == null) continue;
            RAD_MAP.put(biome, Double.parseDouble(biomeInfo.substring(scorePos + 1)));
        }
        for (String biomeInfo : NCConfig.radiation_biome_limits) {
            scorePos = biomeInfo.lastIndexOf(95);
            if (scorePos == -1 || (biome = RegistryHelper.biomeFromRegistry(biomeInfo.substring(0, scorePos))) == null) continue;
            LIMIT_MAP.put(biome, Double.parseDouble(biomeInfo.substring(scorePos + 1)));
        }
        for (int dim : NCConfig.radiation_from_biomes_dims_blacklist) {
            DIM_BLACKLIST.add(dim);
        }
    }
}

