/*
 * Decompiled with CFR 0.152.
 */
package nc.network.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import nc.network.tile.TileUpdatePacket;
import nc.tile.IGui;
import nc.tile.internal.fluid.Tank;
import net.minecraft.util.math.BlockPos;

public class ProcessorUpdatePacket
extends TileUpdatePacket {
    public double time;
    public int energyStored;
    public double baseProcessTime;
    public double baseProcessPower;
    public byte numberOfTanks;
    public List<Tank.TankInfo> tanksInfo;

    public ProcessorUpdatePacket() {
        this.messageValid = false;
    }

    public ProcessorUpdatePacket(BlockPos pos, double time, int energyStored, double baseProcessTime, double baseProcessPower, List<Tank> tanks) {
        this.pos = pos;
        this.time = time;
        this.energyStored = energyStored;
        this.baseProcessTime = baseProcessTime;
        this.baseProcessPower = baseProcessPower;
        this.numberOfTanks = (byte)tanks.size();
        this.tanksInfo = Tank.TankInfo.infoList(tanks);
        this.messageValid = true;
    }

    @Override
    public void readMessage(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.time = buf.readDouble();
        this.energyStored = buf.readInt();
        this.baseProcessTime = buf.readDouble();
        this.baseProcessPower = buf.readDouble();
        this.numberOfTanks = buf.readByte();
        this.tanksInfo = Tank.TankInfo.readBuf(buf, this.numberOfTanks);
    }

    @Override
    public void writeMessage(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeDouble(this.time);
        buf.writeInt(this.energyStored);
        buf.writeDouble(this.baseProcessTime);
        buf.writeDouble(this.baseProcessPower);
        buf.writeByte((int)this.numberOfTanks);
        for (Tank.TankInfo info : this.tanksInfo) {
            info.writeBuf(buf);
        }
    }

    public static class Handler
    extends TileUpdatePacket.Handler<ProcessorUpdatePacket, IGui> {
        @Override
        protected void onPacket(ProcessorUpdatePacket message, IGui processor) {
            processor.onGuiPacket(message);
        }
    }
}

