/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.util.NCUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ToggleTankOutputSettingPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    int tank;
    int setting;

    public ToggleTankOutputSettingPacket() {
        this.messageValid = false;
    }

    public ToggleTankOutputSettingPacket(ITileFluid machine, int tank, TankOutputSetting setting) {
        this.pos = machine.getTilePos();
        this.tank = tank;
        this.setting = setting.ordinal();
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.tank = buf.readInt();
            this.setting = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tank);
        buf.writeInt(this.setting);
    }

    public static class Handler
    implements IMessageHandler<ToggleTankOutputSettingPacket, IMessage> {
        public IMessage onMessage(ToggleTankOutputSettingPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ToggleTankOutputSettingPacket message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (tile instanceof ITileFluid) {
                ITileFluid machine = (ITileFluid)tile;
                TankOutputSetting setting = TankOutputSetting.values()[message.setting];
                machine.setTankOutputSetting(message.tank, setting);
                if (setting == TankOutputSetting.VOID) {
                    machine.clearTank(message.tank);
                }
                machine.markDirtyAndNotify();
            }
        }
    }
}

