/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.WorldHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

final class MultiblockWorldRegistry {
    private World worldObj;
    private final Set<MultiblockBase> multiblocks;
    private final Set<MultiblockBase> dirtyMultiblocks;
    private final Set<MultiblockBase> deadMultiblocks;
    private Set<IMultiblockPart> orphanedParts;
    private final Set<IMultiblockPart> detachedParts;
    private final HashMap<Long, Set<IMultiblockPart>> partsAwaitingChunkLoad;
    private final Object partsAwaitingChunkLoadMutex;
    private final Object orphanedPartsMutex;

    public MultiblockWorldRegistry(World world) {
        this.worldObj = world;
        this.multiblocks = new ObjectOpenHashSet();
        this.deadMultiblocks = new ObjectOpenHashSet();
        this.dirtyMultiblocks = new ObjectOpenHashSet();
        this.detachedParts = new ObjectOpenHashSet();
        this.orphanedParts = new ObjectOpenHashSet();
        this.partsAwaitingChunkLoad = new HashMap();
        this.partsAwaitingChunkLoadMutex = new Object();
        this.orphanedPartsMutex = new Object();
    }

    public void tickStart() {
        if (this.multiblocks.size() > 0) {
            for (MultiblockBase multiblock : this.multiblocks) {
                if (multiblock.WORLD != this.worldObj || multiblock.WORLD.field_72995_K != this.worldObj.field_72995_K) continue;
                if (multiblock.isEmpty()) {
                    this.deadMultiblocks.add(multiblock);
                    continue;
                }
                multiblock.updateMultiblockEntity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMultiblockChanges() {
        ArrayList mergePools = null;
        if (this.orphanedParts.size() > 0) {
            Object orphansToProcess = null;
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                if (this.orphanedParts.size() > 0) {
                    orphansToProcess = this.orphanedParts;
                    this.orphanedParts = new ObjectOpenHashSet();
                }
            }
            if (orphansToProcess != null && orphansToProcess.size() > 0) {
                Iterator iterator = orphansToProcess.iterator();
                while (iterator.hasNext()) {
                    IMultiblockPart orphan = (IMultiblockPart)iterator.next();
                    BlockPos coord = orphan.getTilePos();
                    if (!this.worldObj.func_175667_e(coord) || orphan.isPartInvalid()) continue;
                    if (MultiblockWorldRegistry.getMultiblockPartFromWorld(this.worldObj, coord) != orphan) continue;
                    Set set = orphan.attachToNeighbors();
                    if (set == null) {
                        Object newMultiblock = orphan.createNewMultiblock();
                        ((MultiblockBase)newMultiblock).attachBlock(orphan);
                        this.multiblocks.add((MultiblockBase)newMultiblock);
                        continue;
                    }
                    if (set.size() <= 1) continue;
                    if (mergePools == null) {
                        mergePools = new ArrayList();
                    }
                    ArrayList<Set> candidatePools = new ArrayList<Set>();
                    for (Set set2 : mergePools) {
                        if (Collections.disjoint(set2, set)) continue;
                        candidatePools.add(set2);
                    }
                    if (candidatePools.size() <= 0) {
                        mergePools.add(set);
                        continue;
                    }
                    if (candidatePools.size() == 1) {
                        ((Set)candidatePools.get(0)).addAll(set);
                        continue;
                    }
                    Set masterPool = (Set)candidatePools.get(0);
                    for (int i = 1; i < candidatePools.size(); ++i) {
                        Set set3 = (Set)candidatePools.get(i);
                        masterPool.addAll(set3);
                        mergePools.remove(set3);
                    }
                    masterPool.addAll(set);
                }
            }
        }
        if (mergePools != null && mergePools.size() > 0) {
            for (Set set : mergePools) {
                MultiblockBase newMaster = null;
                for (MultiblockBase multiblock : set) {
                    if (newMaster != null && !multiblock.shouldConsume(newMaster)) continue;
                    newMaster = multiblock;
                }
                if (newMaster == null) {
                    FMLLog.severe((String)"Multiblock system checked a merge pool of size %d, found no master candidates. This should never happen.", (Object[])new Object[]{set.size()});
                    continue;
                }
                this.addDirtyMultiblock(newMaster);
                for (MultiblockBase multiblock : set) {
                    if (multiblock == newMaster) continue;
                    newMaster.assimilate(multiblock);
                    this.addDeadMultiblock(multiblock);
                    this.addDirtyMultiblock(newMaster);
                }
            }
        }
        if (this.dirtyMultiblocks.size() > 0) {
            Set<IMultiblockPart> newlyDetachedParts = null;
            for (MultiblockBase multiblock : this.dirtyMultiblocks) {
                newlyDetachedParts = multiblock.checkForDisconnections();
                if (!multiblock.isEmpty()) {
                    multiblock.recalculateMinMaxCoords();
                    multiblock.checkIfMachineIsWhole();
                } else {
                    this.addDeadMultiblock(multiblock);
                }
                if (newlyDetachedParts == null || newlyDetachedParts.size() <= 0) continue;
                this.detachedParts.addAll(newlyDetachedParts);
            }
            this.dirtyMultiblocks.clear();
        }
        if (this.deadMultiblocks.size() > 0) {
            for (MultiblockBase multiblockBase : this.deadMultiblocks) {
                if (!multiblockBase.isEmpty()) {
                    FMLLog.severe((String)"Found a non-empty multiblock. Forcing it to shed its blocks and die. This should never happen!", (Object[])new Object[0]);
                    this.detachedParts.addAll(multiblockBase.detachAllBlocks());
                }
                this.multiblocks.remove(multiblockBase);
            }
            this.deadMultiblocks.clear();
        }
        for (IMultiblockPart iMultiblockPart : this.detachedParts) {
            iMultiblockPart.assertDetached();
        }
        this.addAllOrphanedPartsThreadsafe(this.detachedParts);
        this.detachedParts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartAdded(IMultiblockPart part) {
        BlockPos worldLocation = part.getTilePos();
        if (!this.worldObj.func_175667_e(worldLocation)) {
            long chunkHash = WorldHelper.getChunkXZHashFromBlock(worldLocation);
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                Object partSet;
                if (!this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    partSet = new ObjectOpenHashSet();
                    this.partsAwaitingChunkLoad.put(chunkHash, (Set<IMultiblockPart>)partSet);
                } else {
                    partSet = this.partsAwaitingChunkLoad.get(chunkHash);
                }
                partSet.add(part);
            }
        } else {
            this.addOrphanedPartThreadsafe(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartRemovedFromWorld(IMultiblockPart part) {
        long hash;
        BlockPos coord = part.getTilePos();
        if (coord != null && this.partsAwaitingChunkLoad.containsKey(hash = WorldHelper.getChunkXZHashFromBlock(coord))) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(hash)) {
                    this.partsAwaitingChunkLoad.get(hash).remove(part);
                    if (this.partsAwaitingChunkLoad.get(hash).size() <= 0) {
                        this.partsAwaitingChunkLoad.remove(hash);
                    }
                }
            }
        }
        this.detachedParts.remove(part);
        if (this.orphanedParts.contains(part)) {
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                this.orphanedParts.remove(part);
            }
        }
        part.assertDetached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldUnloaded() {
        this.multiblocks.clear();
        this.deadMultiblocks.clear();
        this.dirtyMultiblocks.clear();
        this.detachedParts.clear();
        Object object = this.partsAwaitingChunkLoadMutex;
        synchronized (object) {
            this.partsAwaitingChunkLoad.clear();
        }
        object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.clear();
        }
        this.worldObj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkLoaded(int chunkX, int chunkZ) {
        long chunkHash = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    this.addAllOrphanedPartsThreadsafe((Collection<? extends IMultiblockPart>)this.partsAwaitingChunkLoad.get(chunkHash));
                    this.partsAwaitingChunkLoad.remove(chunkHash);
                }
            }
        }
    }

    public void addDeadMultiblock(MultiblockBase deadMultiblock) {
        this.deadMultiblocks.add(deadMultiblock);
    }

    public void addDirtyMultiblock(MultiblockBase dirtyMultiblock) {
        this.dirtyMultiblocks.add(dirtyMultiblock);
    }

    public Set<MultiblockBase> getMultiblocks() {
        return Collections.unmodifiableSet(this.multiblocks);
    }

    protected static IMultiblockPart getMultiblockPartFromWorld(World world, BlockPos position) {
        TileEntity te = world.func_175625_s(position);
        return te instanceof IMultiblockPart ? (IMultiblockPart)te : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphanedPartThreadsafe(IMultiblockPart part) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.add(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllOrphanedPartsThreadsafe(Collection<? extends IMultiblockPart> parts) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.addAll(parts);
        }
    }
}

