/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import nc.NuclearCraft;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.IMultiblockRegistry;
import nc.multiblock.MultiblockBase;
import nc.multiblock.TileBeefBase;
import nc.multiblock.validation.IMultiblockValidator;
import nc.util.NCUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLLog;

public abstract class MultiblockTileBase<T extends MultiblockBase>
extends TileBeefBase
implements IMultiblockPart<T> {
    private T multiblock = null;
    protected final Class<T> tClass;
    private boolean visited;
    private boolean saveMultiblockData;
    private NBTTagCompound cachedMultiblockData;
    private boolean paused;
    private static final IMultiblockRegistry REGISTRY = NuclearCraft.proxy.initMultiblockRegistry();

    public MultiblockTileBase(Class<T> tClass) {
        this.tClass = tClass;
        this.visited = false;
        this.saveMultiblockData = false;
        this.paused = false;
        this.cachedMultiblockData = null;
    }

    @Override
    public Class<T> getMultiblockType() {
        return this.tClass;
    }

    @Override
    public Set<T> attachToNeighbors() {
        IMultiblockPart<T>[] partsToCheck;
        Set multiblocks = null;
        MultiblockBase<Object> bestMultiblock = null;
        for (IMultiblockPart<T> neighborPart : partsToCheck = this.getNeighboringParts()) {
            T candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblock()).getClass().equals(this.getMultiblockType())) continue;
            if (multiblocks == null) {
                multiblocks = new ObjectOpenHashSet();
                bestMultiblock = candidate;
            } else if (!multiblocks.contains(candidate) && ((MultiblockBase)candidate).shouldConsume(bestMultiblock)) {
                bestMultiblock = candidate;
            }
            multiblocks.add(candidate);
        }
        if (bestMultiblock != null) {
            this.multiblock = bestMultiblock;
            bestMultiblock.attachBlock(this);
        }
        return multiblocks;
    }

    @Override
    public void assertDetached() {
        if (this.multiblock != null) {
            BlockPos coord = this.field_174879_c;
            FMLLog.info((String)"[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", (Object[])new Object[]{coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()});
            this.multiblock = null;
        }
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        if (TileBeefBase.SyncReason.FullSync == syncReason) {
            if (data.func_74764_b("multiblockData")) {
                this.cachedMultiblockData = data.func_74775_l("multiblockData");
            }
        } else if (data.func_74764_b("multiblockData")) {
            NBTTagCompound tag = data.func_74775_l("multiblockData");
            if (this.isConnected()) {
                ((MultiblockBase)this.getMultiblock()).syncDataFrom(tag, syncReason);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        if (TileBeefBase.SyncReason.FullSync == syncReason) {
            if (this.isMultiblockSaveDelegate() && this.isConnected()) {
                NBTTagCompound multiblockData = new NBTTagCompound();
                ((MultiblockBase)this.multiblock).syncDataTo(multiblockData, syncReason);
                data.func_74782_a("multiblockData", (NBTBase)multiblockData);
            }
        } else if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((MultiblockBase)this.getMultiblock()).syncDataTo(tag, syncReason);
            data.func_74782_a("multiblockData", (NBTBase)tag);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public void func_145829_t() {
        super.func_145829_t();
        REGISTRY.onPartAdded(this.func_145831_w(), this);
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(T var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.multiblock != null;
    }

    @Override
    public T getMultiblock() {
        return this.multiblock;
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(T newMultiblock) {
        assert (this.multiblock != newMultiblock);
        this.multiblock = newMultiblock;
    }

    @Override
    public void onAttached(T newMultiblock) {
        this.multiblock = newMultiblock;
    }

    @Override
    public void onDetached(T oldMultiblock) {
        this.multiblock = null;
    }

    @Override
    public abstract T createNewMultiblock();

    @Override
    public IMultiblockPart<T>[] getNeighboringParts() {
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        BlockPos partPosition = this.field_174879_c;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPosition = partPosition.func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(neighborPosition);
            if (!(te instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        return neighborParts.toArray(new IMultiblockPart[neighborParts.size()]);
    }

    @Override
    public void onOrphaned(T multiblock, int oldSize, int newSize) {
        this.func_70296_d();
        this.func_145831_w().func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public boolean isPartInvalid() {
        return this.func_145837_r();
    }

    protected void doStandardNullControllerResponse(T controller) {
        if (controller == null) {
            throw this.nullControllerError();
        }
        if (this.getMultiblock() == null) {
            this.nullControllerWarn();
            this.onAttached(controller);
        }
    }

    protected void setStandardLastError(IMultiblockValidator validator) {
        validator.setLastError("nuclearcraft.multiblock_validation.invalid_block", this.func_174877_v(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.getBlock(this.func_174877_v()).func_149732_F());
    }

    protected IllegalArgumentException nullControllerError() {
        return new IllegalArgumentException("Attempted to attach " + this.getBlock(this.func_174877_v()).func_149732_F() + " to a null controller. This should never happen - please report this bug to the NuclearCraft GitHub repo!");
    }

    protected void nullControllerWarn() {
        NCUtil.getLogger().warn(this.getBlock(this.func_174877_v()).func_149732_F() + " at (%d, %d, %d) is being assembled without being attached to a controller. It is recommended that the multiblock is completely disassambled and rebuilt if these errors continue!", (Object)this.func_174877_v().func_177958_n(), (Object)this.func_174877_v().func_177956_o(), (Object)this.func_174877_v().func_177952_p());
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.multiblock != null) {
            ((MultiblockBase)this.multiblock).detachBlock(this, chunkUnloading);
            this.multiblock = null;
        }
        REGISTRY.onPartRemovedFromWorld(this.func_145831_w(), this);
    }

    protected void markMultiblockForRenderUpdate() {
        T multiblock = this.getMultiblock();
        if (null != multiblock) {
            ((MultiblockBase)multiblock).markMultiblockForRenderUpdate();
        }
    }
}

