/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TRSRTransformation;

public final class ModelHelper {
    public static BakedQuad transform(BakedQuad quad, final TRSRTransformation transform) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        VertexTransformer consumer = new VertexTransformer((IVertexConsumer)builder){

            public void put(int element, float ... data) {
                VertexFormatElement formatElement = DefaultVertexFormats.field_176599_b.func_177348_c(element);
                switch (formatElement.func_177375_c()) {
                    case POSITION: {
                        float[] newData = new float[4];
                        Vector4f vec = new Vector4f(data);
                        transform.getMatrix().transform((Tuple4f)vec);
                        vec.get(newData);
                        this.parent.put(element, newData);
                        break;
                    }
                    default: {
                        this.parent.put(element, data);
                    }
                }
            }
        };
        quad.pipe((IVertexConsumer)consumer);
        return builder.build();
    }

    public static IBakedModel getBakedModel(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            IBlockState blockState = block.func_176203_a(stack.func_77960_j());
            return ModelHelper.getBakedModel(blockState);
        }
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static IBakedModel getBakedModel(IBlockState blockState) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(blockState);
    }

    public static List<BakedQuad> getQuads(ItemStack stack, long rand) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            IBlockState blockState = block.func_176203_a(stack.func_77960_j());
            IBakedModel bakedModel = ModelHelper.getBakedModel(blockState);
            ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
            for (EnumFacing facing : EnumFacing.values()) {
                result.addAll(bakedModel.func_188616_a(blockState, facing, rand));
            }
            return result;
        }
        IBakedModel bakedModel = ModelHelper.getBakedModel(stack);
        return bakedModel.func_188616_a(null, null, rand);
    }

    private ModelHelper() {
    }
}

