/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile.client;

import com.codetaylor.mc.athenaeum.ModAthenaeumConfig;
import com.codetaylor.mc.athenaeum.network.tile.client.TileDataServiceClientMonitor;
import com.codetaylor.mc.athenaeum.network.tile.client.TileDataTrackerUpdateMonitor;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TileDataServiceOverlayRenderer {
    private static final TileDataServiceOverlayRenderer INSTANCE = new TileDataServiceOverlayRenderer();

    @SubscribeEvent
    public static void onRenderGameOverlayPostEvent(RenderGameOverlayEvent.Post event) {
        if (!ModAthenaeumConfig.TILE_DATA_SERVICE.ENABLED || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution resolution = event.getResolution();
            INSTANCE.renderMonitor(TileDataServiceClientMonitor.TOTAL, resolution.func_78326_a() / 2 - 32 - 128, 100, "Total Rx");
            RayTraceResult traceResult = Minecraft.func_71410_x().field_71476_x;
            if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                TileDataTrackerUpdateMonitor trackerUpdateMonitor;
                Object2ObjectArrayMap<BlockPos, Object2IntArrayMap<Class>> updateMap;
                Object2IntArrayMap map;
                BlockPos blockPos = traceResult.func_178782_a();
                TileDataServiceClientMonitor monitor = TileDataServiceClientMonitor.findMonitorForPosition(blockPos);
                int x = resolution.func_78326_a() / 2 - 32 + 128;
                int y = 100;
                if (monitor != null) {
                    String title = "[" + blockPos.func_177958_n() + ", " + blockPos.func_177956_o() + ", " + blockPos.func_177952_p() + "]";
                    INSTANCE.renderMonitor(monitor, x, y, title);
                }
                if ((map = (Object2IntArrayMap)(updateMap = (trackerUpdateMonitor = TileDataServiceClientMonitor.getTrackerUpdateMonitor()).getPublicTrackerUpdateMap()).get((Object)blockPos)) != null) {
                    ObjectIterator iterator = map.object2IntEntrySet().iterator();
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    int index = 0;
                    while (iterator.hasNext()) {
                        Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                        Class dataClass = (Class)entry.getKey();
                        int count = entry.getIntValue();
                        fontRenderer.func_175063_a(dataClass.getSimpleName() + " " + count, (float)(x + 64 + 5), (float)(y + 9 + index * 10), Color.WHITE.getRGB());
                        ++index;
                    }
                }
            }
        }
    }

    public void renderMonitor(TileDataServiceClientMonitor monitor, int x, int y, String title) {
        int trackedIndex = ModAthenaeumConfig.TILE_DATA_SERVICE.TRACKING_INDEX;
        int totalWidth = 64;
        int size = monitor.size();
        if (size == 0) {
            return;
        }
        int max = 0;
        int min = Integer.MAX_VALUE;
        int minActual = Integer.MAX_VALUE;
        int total = 0;
        int tracked = 0;
        for (int i = 0; i < size; ++i) {
            int count = monitor.get(i);
            total += count;
            if (i == trackedIndex) {
                tracked = count;
            }
            if (count > max) {
                max = count;
            }
            if (count > 0 && count < min) {
                min = count;
            }
            if (count >= minActual) continue;
            minActual = count;
        }
        if (min > max) {
            min = 0;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = fontRenderer.func_78256_a(title);
        fontRenderer.func_175063_a(title, (float)((double)x - (double)textWidth / 2.0 + (double)totalWidth / 2.0), (float)(y - 9), Color.WHITE.getRGB());
        String text = "\u00c2\u00a7a" + min + " \u00c2\u00a7e" + (int)((float)total / (float)size) + " \u00c2\u00a7c" + max + " \u00c2\u00a79" + tracked;
        int textWidth2 = fontRenderer.func_78256_a(text);
        fontRenderer.func_175063_a(text, (float)((double)x - (double)textWidth2 / 2.0 + (double)totalWidth / 2.0), (float)y, Color.WHITE.getRGB());
        if (max == 0) {
            return;
        }
        if (minActual != max) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder renderer = tessellator.func_178180_c();
            GlStateManager.func_179090_x();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int height = 1;
            int avg = (int)((float)total / (float)size);
            TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, x, y += 9, totalWidth, size, 0.0f, 0.0f, 0.0f, 0.75f);
            int trackedX = 0;
            int innerY = y - 1;
            for (int i = 0; i < size; ++i) {
                float widthScalar = (float)monitor.get(i) / (float)max;
                int width = (int)((float)totalWidth * widthScalar);
                innerY += height;
                if (i == trackedIndex) {
                    trackedX = width;
                    continue;
                }
                if (width == totalWidth) {
                    TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, x, innerY, width, height, 1.0f, 0.0f, 0.0f, 0.75f);
                    continue;
                }
                if ((float)width < (float)min / (float)max * (float)totalWidth + 1.0f) {
                    TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, x, innerY, width, height, 0.0f, 1.0f, 0.0f, 0.75f);
                    continue;
                }
                TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, x, innerY, width, height, 1.0f, 1.0f, 1.0f, 0.5f);
            }
            TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, (int)((float)avg / (float)max * (float)totalWidth + (float)x), y, 1.0f, size, 1.0f, 1.0f, 0.0f, 1.0f);
            TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, (int)((float)min / (float)max * (float)totalWidth + (float)x), y, 1.0f, size, 0.0f, 1.0f, 0.0f, 1.0f);
            TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, totalWidth + x, y, 1.0f, size, 1.0f, 0.0f, 0.0f, 1.0f);
            if (trackedX > 0) {
                TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, x, trackedIndex + y, trackedX, 1, 0.33333334f, 0.33333334f, 1.0f, 1.0f);
                TileDataServiceOverlayRenderer.bufferColoredQuad(renderer, trackedX + x, y, 1.0f, size, 0.33333334f, 0.33333334f, 1.0f, 1.0f);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        }
    }

    private static void bufferColoredQuad(BufferBuilder renderer, int x, int y, float width, int height, float red, float green, float blue, float alpha) {
        renderer.func_181662_b((double)x, (double)y, 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + height), 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)((float)x + width), (double)(y + height), 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)((float)x + width), (double)y, 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
    }
}

