/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.spi;

import com.codetaylor.mc.athenaeum.interaction.api.InteractionRenderers;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBase;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class InteractionItemStack<T extends TileEntity>
extends InteractionBase<T>
implements IInteractionItemStack<T> {
    private static final Vec3d TEXT_OFFSET = new Vec3d(0.0, 0.1, 0.0);
    protected final ItemStackHandler[] stackHandlers;
    protected final int slot;
    protected final Transform transform;
    protected ItemStack lastItemChecked;
    protected boolean lastItemValid;

    public InteractionItemStack(ItemStackHandler[] stackHandlers, int slot, EnumFacing[] sides, AxisAlignedBB bounds, Transform transform) {
        super(sides, bounds);
        this.stackHandlers = stackHandlers;
        this.slot = slot;
        this.transform = transform;
    }

    @Override
    public Transform getTransform(World world, BlockPos pos, IBlockState blockState, ItemStack itemStack, float partialTicks) {
        return this.transform;
    }

    @Override
    public ItemStack getStackInSlot() {
        for (int i = 0; i < this.stackHandlers.length; ++i) {
            ItemStack itemStack = this.stackHandlers[i].getStackInSlot(this.slot);
            if (itemStack.func_190926_b()) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack extract(int amount, boolean simulate) {
        for (int i = 0; i < this.stackHandlers.length; ++i) {
            ItemStack itemStack = this.stackHandlers[i].getStackInSlot(this.slot);
            if (itemStack.func_190926_b()) continue;
            return this.stackHandlers[i].extractItem(this.slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack insert(ItemStack itemStack, boolean simulate) {
        if (!this.isItemStackValid(itemStack)) {
            return itemStack;
        }
        for (int i = 0; i < this.stackHandlers.length; ++i) {
            int count = itemStack.func_190916_E();
            ItemStack result = this.stackHandlers[i].insertItem(this.slot, itemStack, true);
            if (result.func_190916_E() == count) continue;
            return this.stackHandlers[i].insertItem(this.slot, itemStack, simulate);
        }
        return itemStack;
    }

    @Override
    public boolean isEmpty() {
        return this.getStackInSlot().func_190926_b();
    }

    @Override
    public boolean isItemStackValid(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return this.doItemStackValidation(itemStack);
    }

    protected boolean doItemStackValidation(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean interact(IInteraction.EnumType type, T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (!this.allowInteractionWithHand(hand) || !this.allowInteractionWithType(type)) {
            return false;
        }
        BlockPos tilePos = tile.func_174877_v();
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() && type == IInteraction.EnumType.MouseClick || type == IInteraction.EnumType.MouseWheelDown) {
            if (!this.isEmpty()) {
                if (this.doExtract(type, world, player, tilePos)) {
                    this.onExtract(type, world, player, tilePos);
                    return true;
                }
                return false;
            }
        } else {
            ItemStack result;
            ItemStack itemStackToInsert = heldItem;
            int insertIndex = this.getInsertionIndex(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
            ItemStack alternateItemStack = null;
            if (!this.isEmpty() && type == IInteraction.EnumType.MouseWheelUp && (result = this.stackHandlers[insertIndex].insertItem(this.slot, itemStackToInsert, true)).func_190916_E() == itemStackToInsert.func_190916_E()) {
                for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                    result = this.stackHandlers[insertIndex].insertItem(this.slot, itemStack, true);
                    if (result.func_190916_E() == itemStack.func_190916_E()) continue;
                    alternateItemStack = itemStack;
                    break;
                }
            }
            if (alternateItemStack != null) {
                itemStackToInsert = alternateItemStack;
            }
            if (!this.isItemStackValid(itemStackToInsert)) {
                return false;
            }
            int count = itemStackToInsert.func_190916_E();
            ItemStack itemStack = itemStackToInsert.func_77946_l();
            int insertItemCount = this.getInsertItemCount(type, itemStack);
            itemStack.func_190920_e(insertItemCount);
            ItemStack result2 = this.stackHandlers[insertIndex].insertItem(this.slot, itemStack, world.field_72995_K);
            if (result2.func_190916_E() != count) {
                int actualInsertCount = insertItemCount - result2.func_190916_E();
                if (!world.field_72995_K) {
                    itemStackToInsert.func_190920_e(itemStackToInsert.func_190916_E() - actualInsertCount);
                }
                itemStack.func_190920_e(actualInsertCount);
                this.onInsert(type, itemStack, world, player, hitPos);
                return true;
            }
        }
        return false;
    }

    protected int getInsertItemCount(IInteraction.EnumType type, ItemStack itemStack) {
        if (type == IInteraction.EnumType.MouseWheelUp) {
            return 1;
        }
        return itemStack.func_190916_E();
    }

    protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
    }

    protected void onExtract(IInteraction.EnumType type, World world, EntityPlayer player, BlockPos pos) {
        if (!world.field_72995_K && type == IInteraction.EnumType.MouseClick) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.25f, (float)(1.0 + RandomHelper.random().nextGaussian() * (double)0.4f));
        }
    }

    protected boolean doExtract(IInteraction.EnumType type, World world, EntityPlayer player, BlockPos tilePos) {
        int extractItemCount = type == IInteraction.EnumType.MouseWheelDown ? 1 : Integer.MAX_VALUE;
        ItemStack result = this.extract(extractItemCount, world.field_72995_K);
        if (!result.func_190926_b()) {
            if (!world.field_72995_K) {
                StackHelper.addToInventoryOrSpawn(world, player, result, tilePos, 1.0, false, type == IInteraction.EnumType.MouseClick);
            }
            return true;
        }
        return false;
    }

    protected int getInsertionIndex(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
        InteractionRenderers.ITEM_STACK.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
        InteractionRenderers.ITEM_STACK.renderSolidPassText(this, world, fontRenderer, yaw, offset, pos, blockState, partialTicks);
    }

    @Override
    public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
        return TEXT_OFFSET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
        return InteractionRenderers.ITEM_STACK.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
    }

    @Override
    public boolean forceRenderAdditivePassWhileSneaking() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderAdditivePassForHeldItem(ItemStack heldItemMainHand) {
        return !heldItemMainHand.func_190926_b();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderAdditivePassForStackInSlot(boolean sneaking, ItemStack heldItemMainHand) {
        return heldItemMainHand.func_190926_b() || sneaking;
    }
}

