/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.ic2;

import appeng.api.AEApi;
import appeng.api.config.TunnelType;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.integration.IntegrationHelper;
import appeng.integration.abstraction.IC2PowerSink;
import appeng.integration.abstraction.IIC2;
import appeng.integration.modules.ic2.IC2PowerSinkAdapter;
import appeng.integration.modules.ic2.IC2RecipeInput;
import appeng.integration.modules.ic2.energy.PoweredItemManager;
import appeng.tile.powersink.IExternalPowerSink;
import ic2.api.energy.prefab.BasicSinkSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class IC2Module
implements IIC2 {
    private static final String[] IC2_CABLE_TYPES = new String[]{"copper", "glass", "gold", "iron", "tin", "detector", "splitter"};

    public IC2Module() {
        IntegrationHelper.testClassExistence(this, IEnergyTile.class);
        IntegrationHelper.testClassExistence(this, IEnergyAcceptor.class);
        IntegrationHelper.testClassExistence(this, IEnergyEmitter.class);
        IntegrationHelper.testClassExistence(this, BasicSinkSource.class);
        IntegrationHelper.testClassExistence(this, IC2Items.class);
        IntegrationHelper.testClassExistence(this, IBackupElectricItemManager.class);
        IntegrationHelper.testClassExistence(this, Recipes.class);
        IntegrationHelper.testClassExistence(this, IRecipeInput.class);
    }

    @Override
    public void postInit() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        for (String string : IC2_CABLE_TYPES) {
            reg.addNewAttunement(this.getCable(string), TunnelType.IC2_POWER);
        }
        ElectricItem.registerBackupManager((IBackupElectricItemManager)new PoweredItemManager());
    }

    private ItemStack getItem(String name, String variant) {
        return IC2Items.getItem((String)name, (String)variant);
    }

    private ItemStack getCable(String type) {
        return this.getItem("cable", "type:" + type);
    }

    @Override
    public IC2PowerSink createPowerSink(TileEntity tileEntity, IExternalPowerSink externalSink) {
        return new IC2PowerSinkAdapter(tileEntity, externalSink);
    }

    @Override
    public void maceratorRecipe(ItemStack in, ItemStack out) {
        Recipes.macerator.addRecipe((IRecipeInput)new IC2RecipeInput(in, in.func_190916_E()), null, false, new ItemStack[]{out});
    }
}

