/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.storage.BlockSkyChest;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.IItemRendering;
import appeng.client.render.tesr.SkyChestTESR;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SkyChestRenderingCustomizer
extends BlockRenderingCustomizer {
    private final BlockSkyChest.SkyChestType type;

    public SkyChestRenderingCustomizer(BlockSkyChest.SkyChestType type) {
        this.type = type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void customize(IBlockRendering rendering, IItemRendering itemRendering) {
        rendering.tesr(new SkyChestTESR());
        String modelName = this.getModelFromType();
        ModelResourceLocation model = new ModelResourceLocation("appliedenergistics2:" + modelName, "inventory");
        itemRendering.model(model).variants(new ResourceLocation[]{model});
    }

    private String getModelFromType() {
        String modelName;
        switch (this.type) {
            default: {
                modelName = "sky_stone_chest";
                break;
            }
            case BLOCK: {
                modelName = "smooth_sky_stone_chest";
            }
        }
        return modelName;
    }
}

