/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.common;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.shared.FoamFixShared;

public class WorldNuller {
    private final List<UnloadEntry> unload_queue_client = Lists.newArrayList();

    private WorldNuller() {
    }

    public static void init() {
    }

    public static void initClient() {
        FoamFix.getLogger().info("Registered client-side world unload notifier!");
        MinecraftForge.EVENT_BUS.register((Object)new ClientNuller());
    }

    @SubscribeEvent
    public void queueWorldNull(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            this.unload_queue_client.add(new UnloadEntry(event.getWorld()));
        }
    }

    void tick(TickEvent event, boolean server) {
        List<Object> unload_queue;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        List<Object> list = unload_queue = server ? Collections.emptyList() : this.unload_queue_client;
        if (unload_queue.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        unload_queue.removeIf(e -> e.tick(now));
    }

    public static class ClientNuller
    extends WorldNuller {
        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            this.tick((TickEvent)event, false);
        }
    }

    public static class ServerNuller
    extends WorldNuller {
        @SubscribeEvent
        public void serverTick(TickEvent.ServerTickEvent event) {
            this.tick((TickEvent)event, true);
        }
    }

    static class UnloadEntry {
        WeakReference<World> worldRef;
        long timeOfUnload;
        String name;
        static boolean spam = true;

        UnloadEntry(World world) {
            this.worldRef = new WeakReference<World>(world);
            this.timeOfUnload = System.currentTimeMillis();
            this.name = "<" + world.toString() + " " + world.field_73011_w.getDimension() + " " + world.func_72863_F().func_73148_d() + ">";
        }

        static void log(String msg) {
            FoamFix.getLogger().info(msg);
        }

        boolean tick(long now) {
            long passedTime = now - this.timeOfUnload;
            int delay = FoamFixShared.config.gbWorldUnloadTime * 1000;
            if (passedTime < (long)delay) {
                return false;
            }
            World world = (World)this.worldRef.get();
            if (world != null && FoamFixShared.config.gbForgeGCNonUnloaded) {
                world = null;
                UnloadEntry.log("Unloaded world " + this.name + " was not garbage collected, forcing GC as requested...");
                System.gc();
                world = (World)this.worldRef.get();
            }
            int secs = delay / 1000;
            if (world == null) {
                UnloadEntry.log("Unloaded world " + this.name + " was garbage collected.");
                return true;
            }
            if (world instanceof WorldServer) {
                if (DimensionManager.getWorld((int)world.field_73011_w.getDimension()) == world) {
                    return true;
                }
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server != null && server.field_71305_c != null) {
                    for (WorldServer w : server.field_71305_c) {
                        if (world != w) continue;
                        return true;
                    }
                }
            }
            UnloadEntry.log("Unloaded world " + this.name + " is still hanging around after " + secs + " seconds.");
            if (spam) {
                UnloadEntry.log("This may be due to a world leak, or there is little memory pressure.");
                UnloadEntry.log("Use the relevant FoamFix options to adjust the wait time.");
                spam = false;
            }
            return true;
        }
    }
}

