/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.ARBCopyImage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.api.IFoamFixSprite;
import pl.asie.foamfix.shared.FoamFixShared;

public class FastTextureAtlasSprite
extends TextureAtlasSprite
implements IFoamFixSprite {
    private int textureId = -1;
    private int mipLevels = 0;

    public FastTextureAtlasSprite(String p_i1282_1_) {
        super(p_i1282_1_);
    }

    public void func_94219_l() {
        if (FoamFixShared.config.clDisableTextureAnimations) {
            return;
        }
        ++this.field_110983_h;
        if (this.field_110983_h >= this.field_110982_k.func_110472_a(this.field_110973_g)) {
            int i = this.field_110982_k.func_110468_c(this.field_110973_g);
            int j = this.field_110982_k.func_110473_c() == 0 ? this.field_110976_a.size() : this.field_110982_k.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % j;
            this.field_110983_h = 0;
            int k = this.field_110982_k.func_110468_c(this.field_110973_g);
            if (i != k && k >= 0 && k < this.field_110976_a.size()) {
                if (this.textureId != -1) {
                    int destTex = GL11.glGetInteger((int)32873);
                    FastTextureAtlasSprite.checkGLError("updateAnimation | fastPath getPreviousTexture");
                    GL11.glBindTexture((int)3553, (int)0);
                    FastTextureAtlasSprite.checkGLError("updateAnimation | fastPath unbindTex");
                    for (int mip = 0; mip <= this.mipLevels; ++mip) {
                        ARBCopyImage.glCopyImageSubData((int)this.textureId, (int)3553, (int)mip, (int)(this.field_130223_c * k >> mip), (int)0, (int)0, (int)destTex, (int)3553, (int)mip, (int)(this.field_110975_c >> mip), (int)(this.field_110974_d >> mip), (int)0, (int)(this.field_130223_c >> mip), (int)(this.field_130224_d >> mip), (int)1);
                        FastTextureAtlasSprite.checkGLError("updateAnimation | fastPath mip=" + mip);
                    }
                    GL11.glBindTexture((int)3553, (int)destTex);
                    FastTextureAtlasSprite.checkGLError("updateAnimation | fastPath rebindTex");
                } else {
                    int[][] frameData;
                    FastTextureAtlasSprite.uploadTextureMaxMips(this.mipLevels, frameData, this.field_130223_c, this.field_130224_d, this.field_110975_c, this.field_110974_d, false, false, (frameData = (int[][])this.field_110976_a.get(k)).length > 1);
                    FastTextureAtlasSprite.checkGLError("updateAnimation | slowPath");
                }
            }
        } else if (this.field_110982_k.func_177219_e()) {
            this.func_180599_n();
        }
    }

    private int interpolateColor(double ratio, int from, int to) {
        return (int)(ratio * (double)from + (1.0 - ratio) * (double)to);
    }

    private boolean interpolateFrame(int[] to, int[] from1, int[] from2, double ratio) {
        if (from1.length == from2.length) {
            for (int i = 0; i < from1.length; ++i) {
                int color1 = from1[i];
                int color2 = from2[i];
                int colorRed = this.interpolateColor(ratio, color1 >> 16 & 0xFF, color2 >> 16 & 0xFF);
                int colorGreen = this.interpolateColor(ratio, color1 >> 8 & 0xFF, color2 >> 8 & 0xFF);
                int colorBlue = this.interpolateColor(ratio, color1 & 0xFF, color2 & 0xFF);
                to[i] = color1 & 0xFF000000 | colorRed << 16 | colorGreen << 8 | colorBlue;
            }
            return true;
        }
        return false;
    }

    protected void func_180599_n() {
        int frameCount;
        int nextFrameIndex;
        double ratio = 1.0 - (double)this.field_110983_h / (double)this.field_110982_k.func_110472_a(this.field_110973_g);
        int currentFrameIndex = this.field_110982_k.func_110468_c(this.field_110973_g);
        if (currentFrameIndex != (nextFrameIndex = this.field_110982_k.func_110468_c((this.field_110973_g + 1) % (frameCount = this.field_110982_k.func_110473_c() == 0 ? this.field_110976_a.size() : this.field_110982_k.func_110473_c()))) && nextFrameIndex >= 0 && nextFrameIndex < this.field_110976_a.size()) {
            int mipLvl;
            int[][] frame1 = (int[][])this.field_110976_a.get(currentFrameIndex);
            int[][] frame2 = (int[][])this.field_110976_a.get(nextFrameIndex);
            if (this.field_176605_b == null || this.field_176605_b.length != this.mipLevels + 1) {
                this.field_176605_b = new int[this.mipLevels + 1][];
            }
            for (mipLvl = 0; mipLvl <= this.mipLevels && mipLvl < frame1.length && mipLvl < frame2.length; ++mipLvl) {
                if (this.field_176605_b[mipLvl] == null) {
                    this.field_176605_b[mipLvl] = new int[frame1[mipLvl].length];
                }
                this.interpolateFrame(this.field_176605_b[mipLvl], frame1[mipLvl], frame2[mipLvl], ratio);
            }
            FastTextureAtlasSprite.uploadTextureMaxMips(mipLvl, this.field_176605_b, this.field_130223_c, this.field_130224_d, this.field_110975_c, this.field_110974_d, false, false, this.field_176605_b.length > 1);
        }
    }

    public void func_110968_a(List<int[][]> textureData) {
        if (this.textureId != -1) {
            GL11.glDeleteTextures((int)this.textureId);
            this.textureId = -1;
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | deleteTexture");
        }
        super.func_110968_a(textureData);
        if (textureData.size() > 1 && textureData.size() <= FoamFixShared.config.txCacheAnimationMaxFrames && FoamFix.shouldFasterAnimation) {
            int i;
            this.textureId = GL11.glGenTextures();
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | createTexture");
            int prevTex = GL11.glGetInteger((int)32873);
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | getPreviousTexture");
            GL11.glBindTexture((int)3553, (int)this.textureId);
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | bindTexture");
            GL11.glTexParameteri((int)3553, (int)33085, (int)this.mipLevels);
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | setTextureProperties[Mip Levels]");
            GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | setTextureProperties[LOD Min]");
            GL11.glTexParameterf((int)3553, (int)33083, (float)this.mipLevels);
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | setTextureProperties[LOD Max]");
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | setTextureProperties[LOD Bias]");
            for (i = 0; i <= this.mipLevels; ++i) {
                GL11.glTexImage2D((int)3553, (int)i, (int)6408, (int)(this.field_130223_c * this.field_110976_a.size() >> i), (int)(this.field_130224_d >> i), (int)0, (int)32993, (int)5121, (ByteBuffer)null);
                FastTextureAtlasSprite.checkGLError("setFramesTextureData | createMip " + i);
            }
            for (i = 0; i < this.field_110976_a.size(); ++i) {
                FastTextureAtlasSprite.uploadTextureMaxMips(this.mipLevels, (int[][])this.field_110976_a.get(i), this.field_130223_c, this.field_130224_d, this.field_130223_c * i, 0, false, false, this.mipLevels > 0);
                FastTextureAtlasSprite.checkGLError("setFramesTextureData | uploadFrame " + i);
            }
            GL11.glBindTexture((int)3553, (int)prevTex);
            FastTextureAtlasSprite.checkGLError("setFramesTextureData | restoreTexture");
        }
    }

    private static void uploadTextureMaxMips(int maxMips, int[][] data, int width, int height, int originX, int originY, boolean linearFiltering, boolean clamped, boolean mipFiltering) {
        int mips = maxMips >= 0 ? Math.min(maxMips, data.length - 1) : data.length - 1;
        for (int mip = 0; mip <= mips; ++mip) {
            if (!(width >> mip > 0 & height >> mip > 0)) continue;
            TextureUtil.func_147947_a((int)mip, (int[])data[mip], (int)(width >> mip), (int)(height >> mip), (int)(originX >> mip), (int)(originY >> mip), (boolean)linearFiltering, (boolean)clamped, (boolean)mipFiltering);
            FastTextureAtlasSprite.checkGLError("uploadTextureMaxMips mip=" + mip);
        }
    }

    private static void checkGLError(String desc) {
        int error = GL11.glGetError();
        while (error != 0) {
            String errorString = GLU.gluErrorString((int)error);
            FoamFix.getLogger().error("GL Error: " + errorString + "(" + error + ") @ " + desc);
            error = GL11.glGetError();
        }
    }

    public void func_130103_l() {
        super.func_130103_l();
        if (this.textureId != -1) {
            GL11.glDeleteTextures((int)this.textureId);
            this.textureId = -1;
        }
    }

    public void func_147963_d(int p_147963_1_) {
        this.mipLevels = FoamFixShared.config.txMaxAnimationMipLevel >= 0 ? Math.min(FoamFixShared.config.txMaxAnimationMipLevel, p_147963_1_) : p_147963_1_;
        super.func_147963_d(p_147963_1_);
    }

    @Override
    public boolean isStoredOnGPU() {
        return this.textureId != -1 || !this.func_130098_m();
    }
}

