/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.botanicadds.proxy;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tk.zeitheron.botanicadds.BotanicAdditions;
import tk.zeitheron.botanicadds.IHUDRenderable;
import tk.zeitheron.botanicadds.blocks.tiles.TileElvenAltar;
import tk.zeitheron.botanicadds.flowers.base.Flower;
import tk.zeitheron.botanicadds.init.BlocksBA;
import tk.zeitheron.botanicadds.init.ItemsBA;
import tk.zeitheron.botanicadds.items.ItemTerraProtector;
import tk.zeitheron.botanicadds.proxy.CommonProxy;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;

public class ClientProxy
extends CommonProxy {
    public static TextureAtlasSprite terraCatalystOverlay;

    @Override
    public void preInit() {
        ModelLoader.setCustomStateMapper((Block)BlocksBA.DREAMING_POOL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        super.preInit();
    }

    @Override
    public void init() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((s, t) -> Color.HSBtoRGB((float)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L) / 360.0f, 0.25f, 1.0f), new Item[]{ItemsBA.GAIA_SHARD});
        super.init();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent evt) {
        for (Class<? extends SubTileEntity> cl : BotanicAdditions.flowers) {
            Flower fl = cl.getDeclaredAnnotation(Flower.class);
            BotaniaAPIClient.registerSubtileModel(cl, (ModelResourceLocation)new ModelResourceLocation("botanicadds:" + fl.value()));
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        terraCatalystOverlay = ClientProxy.forName(evt.getMap(), "terra_catalyst_overlay", "blocks");
    }

    public static TextureAtlasSprite forName(TextureMap ir, String name, String dir) {
        return ir.func_174942_a(new ResourceLocation("botanicadds", dir + "/" + name));
    }

    @SubscribeEvent
    public void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        ItemStack main = mc.field_71439_g.func_184614_ca();
        ItemStack offhand = mc.field_71439_g.func_184592_cb();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            profiler.func_76320_a("botanicadditions-hud");
            RayTraceResult pos = mc.field_71476_x;
            if (pos != null) {
                TileEntity tile;
                IBlockState state = pos.field_72313_a == RayTraceResult.Type.BLOCK ? mc.field_71441_e.func_180495_p(pos.func_178782_a()) : null;
                Block block = state == null ? null : state.func_177230_c();
                TileEntity tileEntity = tile = pos.field_72313_a == RayTraceResult.Type.BLOCK ? mc.field_71441_e.func_175625_s(pos.func_178782_a()) : null;
                if (tile instanceof IHUDRenderable) {
                    ((IHUDRenderable)tile).renderHUDPlz(mc, event.getResolution());
                }
                if (tile != null && tile instanceof TileElvenAltar) {
                    ((TileElvenAltar)tile).renderHUD(mc, event.getResolution());
                }
            }
        }
    }

    @SubscribeEvent
    public void onToolTipRender(RenderTooltipEvent.PostText evt) {
        NBTTagCompound shield;
        if (evt.getStack().func_190926_b()) {
            return;
        }
        ItemStack stack = evt.getStack();
        Minecraft mc = Minecraft.func_71410_x();
        int width = evt.getWidth();
        int height = 3;
        int tooltipX = evt.getX();
        int tooltipY = evt.getY() - 4;
        FontRenderer font = evt.getFontRenderer();
        if (stack.func_77973_b() instanceof ItemTerraProtector && (shield = stack.func_179543_a("Shield")) != null) {
            float charge = (float)shield.func_74762_e("Charge") / 100000.0f;
            float defense = (float)shield.func_74762_e("Defense") / 100.0f;
            float heat = (float)shield.func_74762_e("Heat") / 1000.0f;
            ClientProxy.drawManaBar(stack, charge, tooltipX, tooltipY, width, height, 0.528f);
            ClientProxy.drawManaBar(stack, defense, tooltipX, tooltipY - height - 1, width, height, defense / 4.0f);
            ClientProxy.drawManaBar(stack, heat, tooltipX, tooltipY - height * 2 - 2, width, height, 0.75f);
        }
    }

    private static void drawManaBar(ItemStack stack, float fraction, int mouseX, int mouseY, int width, int height, float hue) {
        int manaBarWidth = (int)Math.ceil((float)width * fraction);
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)(mouseX - 1), (int)(mouseY - height - 1), (int)(mouseX + width + 1), (int)mouseY, (int)-16777216);
        Gui.func_73734_a((int)mouseX, (int)(mouseY - height), (int)(mouseX + manaBarWidth), (int)mouseY, (int)Color.HSBtoRGB(hue, ((float)Math.sin((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.2) + 1.0f) * 0.1f + 0.6f, 1.0f));
        Gui.func_73734_a((int)(mouseX + manaBarWidth), (int)(mouseY - height), (int)(mouseX + width), (int)mouseY, (int)-11184811);
    }
}

