/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.botanicadds.blocks.tiles;

import com.google.common.base.Predicates;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tk.zeitheron.botanicadds.init.BlocksBA;
import tk.zeitheron.botanicadds.utils.ILastManaAknowledgedTile;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;

public class TileManaTesseract
extends TileSyncableTickable
implements ISparkAttachable,
IManaPool,
ILastManaAknowledgedTile {
    public static final Map<UUID, Int2ObjectMap<List<TileManaTesseract>>> TESSERACTS = new HashMap<UUID, Int2ObjectMap<List<TileManaTesseract>>>();
    public static final int MANA_CAP = 50000;
    public int mana;
    public EnumDyeColor color = EnumDyeColor.WHITE;
    public UUID owner = UUID.randomUUID();
    public int channel;
    public int lastKnownMana = -1;

    public static void addTesseract(TileManaTesseract tile) {
        List<TileManaTesseract> l = TileManaTesseract.getTesseracts(tile);
        if (!l.contains(tile)) {
            l.add(tile);
        }
    }

    public static void removeTesseract(TileManaTesseract tile) {
        List<TileManaTesseract> l = TileManaTesseract.getTesseracts(tile);
        if (l.contains(tile)) {
            l.add(tile);
            if (l.isEmpty()) {
                Int2ObjectArrayMap channels = TESSERACTS.get(tile.owner);
                if (channels == null) {
                    channels = new Int2ObjectArrayMap();
                    TESSERACTS.put(tile.owner, (Int2ObjectMap<List<TileManaTesseract>>)channels);
                }
                channels.remove(tile.channel);
            }
        }
    }

    public static List<TileManaTesseract> getTesseracts(TileManaTesseract tile) {
        ArrayList l;
        if (tile.field_145850_b.field_72995_K) {
            return new ArrayList<TileManaTesseract>();
        }
        Int2ObjectArrayMap channels = TESSERACTS.get(tile.owner);
        if (channels == null) {
            channels = new Int2ObjectArrayMap();
            TESSERACTS.put(tile.owner, (Int2ObjectMap<List<TileManaTesseract>>)channels);
        }
        if ((l = (ArrayList)channels.get(tile.channel)) == null) {
            l = new ArrayList();
            channels.put(tile.channel, l);
        }
        return l;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setLink(int channel) {
        this.channel = channel;
    }

    public static int computeHash(ItemStack stack) {
        return stack.func_77946_l().func_77979_a(1).serializeNBT().hashCode();
    }

    public void tick() {
        if (!ManaNetworkHandler.instance.isPoolIn((TileEntity)this) && !this.func_145837_r()) {
            ManaNetworkEvent.addPool((TileEntity)this);
            TileManaTesseract.addTesseract(this);
        }
        if (this.atTickRate(20) && !this.field_145850_b.field_72995_K) {
            List<TileManaTesseract> tesses = TileManaTesseract.getTesseracts(this);
            tesses.removeIf(t -> t.func_145837_r());
            if (!tesses.isEmpty() && tesses.get(0) == this) {
                long mana = 0L;
                int pools = tesses.size();
                for (TileManaTesseract t2 : tesses) {
                    mana += (long)t2.mana;
                }
                int per = (int)(mana / (long)pools);
                for (TileManaTesseract t3 : tesses) {
                    t3.mana = per;
                    if (t3.mana == per) continue;
                    t3.sendChangesToNearby();
                }
                this.mana = (int)((long)this.mana + (mana - (long)(per * pools)));
            }
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Mana", this.mana);
        nbt.func_74774_a("Color", (byte)this.color.func_176765_a());
        nbt.func_186854_a("Owner", this.owner);
        nbt.func_74768_a("Channel", this.channel);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.mana = nbt.func_74762_e("Mana");
        this.color = EnumDyeColor.func_176766_a((int)nbt.func_74771_c("Color"));
        this.owner = nbt.func_186857_a("Owner");
        this.channel = nbt.func_74762_e("Channel");
    }

    public void func_145843_s() {
        super.func_145843_s();
        ManaNetworkEvent.removePool((TileEntity)this);
        TileManaTesseract.removeTesseract(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ManaNetworkEvent.removePool((TileEntity)this);
        TileManaTesseract.removeTesseract(this);
    }

    public boolean isFull() {
        return this.mana >= 50000;
    }

    public void recieveMana(int mana) {
        this.mana = Math.min(this.mana + mana, 50000);
    }

    public boolean canRecieveManaFromBursts() {
        return this.mana < 50000;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public void attachSpark(ISparkEntity entity) {
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            return (ISparkEntity)sparks.get(0);
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, 50000 - this.mana);
    }

    public boolean areIncomingTranfersDone() {
        return !this.canRecieveManaFromBursts();
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public void setColor(EnumDyeColor color) {
        this.color = color;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 11);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        HUDHandler.drawSimpleManaHUD((int)0x44FF44, (int)this.getLastKnownMana(), (int)50000, (String)BlocksBA.MANA_TESSERACT.func_149732_F(), (ScaledResolution)res);
        int x = res.func_78326_a() / 2 - 11;
        int y = res.func_78328_b() / 2 + 30;
        String str = "Channel: " + Integer.toString(this.channel, 36);
        mc.field_71466_p.func_175065_a(str, (float)(x - mc.field_71466_p.func_78256_a(str) / 2), (float)y, 0xFFFFFF, true);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
    }

    @Override
    public int getLastKnownMana() {
        return this.lastKnownMana;
    }

    @Override
    public void setLastKnownMana(int mana) {
        this.lastKnownMana = mana;
    }

    @Override
    public BlockPos pos() {
        return this.func_174877_v();
    }
}

