/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.botanicadds.blocks.tiles;

import com.google.common.base.Predicates;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.IItemHandler;
import tk.zeitheron.botanicadds.api.GaiaPlateRecipes;
import tk.zeitheron.botanicadds.init.BlocksBA;
import tk.zeitheron.botanicadds.net.PacketGaiaPlateEffect;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;

public class TileGaiaPlate
extends TileMod
implements ISparkAttachable,
ITickable,
IItemHandler {
    private static final BlockPos[] LAPIS_BLOCKS = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)};
    private static final BlockPos[] LIVINGROCK_BLOCKS = new BlockPos[]{new BlockPos(0, 0, 0), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1)};
    private static final String TAG_MANA = "mana";
    public GaiaPlateRecipes.RecipeGaiaPlate recipe;
    public int mana;
    public int maxMana;
    List<EntityItem> groundItems;

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos relativePos : LAPIS_BLOCKS) {
            mb.addComponent(relativePos, BlocksBA.ELVEN_LAPIS_BLOCK.func_176223_P());
        }
        for (BlockPos relativePos : LIVINGROCK_BLOCKS) {
            mb.addComponent(relativePos, BlocksBA.DREAMROCK.func_176223_P());
        }
        mb.addComponent(new BlockPos(0, 1, 0), BlocksBA.GAIA_PLATE.func_176223_P());
        mb.setRenderOffset(new BlockPos(0, 1, 0));
        return mb.makeSet();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.groundItems = this.getItems();
        this.recipe = null;
        if (this.recipe != null) {
            this.maxMana = this.recipe.getMana();
        } else {
            this.recipe = this.areItemsValid(this.groundItems);
            if (this.recipe != null) {
                this.maxMana = this.recipe.getMana();
            }
        }
        boolean removeMana = true;
        if (this.hasValidPlatform() && this.recipe != null) {
            removeMana = false;
            ISparkEntity spark = this.getAttachedSpark();
            if (spark != null) {
                List sparkEntities = SparkHelper.getSparksAround((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 0.5), (double)((double)this.field_174879_c.func_177952_p() + 0.5));
                for (ISparkEntity otherSpark : sparkEntities) {
                    if (spark == otherSpark || otherSpark.getAttachedTile() == null || !(otherSpark.getAttachedTile() instanceof IManaPool)) continue;
                    otherSpark.registerTransfer(spark);
                }
            }
            if (this.mana > 0) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (BlockPos)this.field_174879_c);
                if (this.field_145850_b instanceof WorldServer) {
                    WorldServer ws = (WorldServer)this.field_145850_b;
                    PacketGaiaPlateEffect packet = new PacketGaiaPlateEffect();
                    packet.setPos(this.func_174877_v());
                    for (EntityPlayer player : ws.field_73010_i) {
                        EntityPlayerMP playerMP = (EntityPlayerMP)player;
                        if (!(playerMP.func_174818_b(this.field_174879_c) < 4096.0) || !ws.func_184164_w().func_72694_a(playerMP, this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4)) continue;
                        HCNet.INSTANCE.sendTo((IPacket)packet, playerMP);
                    }
                }
            }
            if (this.mana >= this.maxMana) {
                List<EntityItem> items = this.getItems();
                EntityItem item = items.get(0);
                for (EntityItem otherItem : items) {
                    if (otherItem != item) {
                        otherItem.func_70106_y();
                        continue;
                    }
                    item.func_92058_a(this.recipe.getOutput().func_77946_l());
                }
                this.field_145850_b.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, ModSounds.terrasteelCraft, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.mana = 0;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
        }
        if (removeMana) {
            this.recieveMana(-1000);
        }
    }

    List<EntityItem> getItems() {
        return this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
    }

    GaiaPlateRecipes.RecipeGaiaPlate areItemsValid(List<EntityItem> items) {
        for (GaiaPlateRecipes.RecipeGaiaPlate rgp : GaiaPlateRecipes.gaiaRecipes) {
            if (!rgp.matches(this)) continue;
            return rgp;
        }
        return null;
    }

    boolean hasValidPlatform() {
        return this.checkAll(LAPIS_BLOCKS, BlocksBA.ELVEN_LAPIS_BLOCK) && this.checkAll(LIVINGROCK_BLOCKS, BlocksBA.DREAMROCK);
    }

    boolean checkAll(BlockPos[] relPositions, Block block) {
        for (BlockPos position : relPositions) {
            if (this.checkPlatform(position.func_177958_n(), position.func_177952_p(), block)) continue;
            return false;
        }
        return true;
    }

    boolean checkPlatform(int xOff, int zOff, Block block) {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(xOff, -1, zOff)).func_177230_c() == block;
    }

    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74768_a("maxMana", this.maxMana);
    }

    public void readPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.maxMana = cmp.func_74762_e("maxMana");
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.mana >= this.maxMana;
    }

    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(this.maxMana, this.mana + mana));
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
    }

    public boolean canRecieveManaFromBursts() {
        return this.recipe != null;
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public void attachSpark(ISparkEntity entity) {
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return !this.canRecieveManaFromBursts();
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.maxMana - this.getCurrentMana());
    }

    public int getSlots() {
        return this.groundItems.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.groundItems.get(slot).func_92059_d();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

