/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.botanicadds.blocks;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tk.zeitheron.botanicadds.blocks.tiles.TileElvenAltar;
import tk.zeitheron.botanicadds.init.LexiconBA;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;

public class BlockElvenAltar
extends Block
implements ITileEntityProvider,
IWandable,
ILexiconable,
IWandHUD {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public BlockElvenAltar() {
        super(Material.field_151576_e);
        this.func_149663_c("elven_altar");
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        BotaniaAPI.blacklistBlockFromMagnet((Block)this, (int)Short.MAX_VALUE);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        System.out.println(id + " -> " + param);
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        TileElvenAltar altar = (TileElvenAltar)world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (altar.manaToGet == 0) {
                InventoryHelper.withdrawFromInventory((TileSimpleInventory)altar, (EntityPlayer)player);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)altar);
                return true;
            }
        } else {
            if (altar.isEmpty() && stack.func_190926_b()) {
                altar.trySetLastRecipe(player);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)altar);
                return true;
            }
            if (!stack.func_190926_b()) {
                boolean result = altar.addItem(player, stack, hand);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)altar);
                return result;
            }
        }
        return false;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
        InventoryHelper.dropInventory((TileSimpleInventory)inv, (World)world, (IBlockState)state, (BlockPos)pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileElvenAltar altar = (TileElvenAltar)world.func_175625_s(pos);
        return altar.signal;
    }

    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        ((TileElvenAltar)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconBA.elven_altar;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileElvenAltar();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileElvenAltar();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileElvenAltar)world.func_175625_s(pos)).renderHUD(mc, res);
    }
}

