/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.botanicadds;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.internal.SimpleRegistration;
import com.zeitheron.hammercore.utils.AnnotatedInstanceUtil;
import com.zeitheron.hammercore.utils.ForgeRegistryUtils;
import com.zeitheron.hammercore.utils.ReflectionUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tk.zeitheron.botanicadds.compat.crafttweaker.CraftTweakerCompat;
import tk.zeitheron.botanicadds.compat.crafttweaker.core.ICTCompat;
import tk.zeitheron.botanicadds.flowers.base.Flower;
import tk.zeitheron.botanicadds.init.AltarRecipesBA;
import tk.zeitheron.botanicadds.init.BlocksBA;
import tk.zeitheron.botanicadds.init.ElvenTradesBA;
import tk.zeitheron.botanicadds.init.GaiaPlateRecipesBA;
import tk.zeitheron.botanicadds.init.ItemsBA;
import tk.zeitheron.botanicadds.init.LexiconBA;
import tk.zeitheron.botanicadds.init.PetalRecipesBA;
import tk.zeitheron.botanicadds.init.PoolRecipesBA;
import tk.zeitheron.botanicadds.init.RecipesBA;
import tk.zeitheron.botanicadds.proxy.CommonProxy;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.signature.BasicSignature;
import vazkii.botania.api.subtile.signature.SubTileSignature;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

@Mod.EventBusSubscriber
@Mod(modid="botanicadds", name="Botanic Additions", version="12.2.6", dependencies="required-after:hammercore@[2.0.6.14,);required-after:botania", certificateFingerprint="9f5e2a811a8332a842b34f6967b7db0ac4f24856", updateJSON="http://dccg.herokuapp.com/api/fmluc/310637", acceptedMinecraftVersions="[1.12.2]")
public class BotanicAdditions {
    public static final List<Class<? extends SubTileEntity>> flowers = null;
    @SidedProxy(serverSide="tk.zeitheron.botanicadds.proxy.CommonProxy", clientSide="tk.zeitheron.botanicadds.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static final Logger LOG;
    public static final CreativeTabs TAB;

    @Mod.EventHandler
    public void certificateViolation(FMLFingerprintViolationEvent e) {
        LOG.warn("*****************************");
        LOG.warn("WARNING: Somebody has been tampering with BotanicAdditions jar!");
        LOG.warn("It is highly recommended that you redownload mod from https://www.curseforge.com/projects/310637 !");
        LOG.warn("*****************************");
        HammerCore.invalidCertificates.put("botanicadds", "https://www.curseforge.com/projects/310637");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        ReflectionUtil.setStaticFinalField(BotanicAdditions.class, (String)"flowers", (Object)AnnotatedInstanceUtil.getTypes((ASMDataTable)e.getAsmData(), Flower.class, SubTileEntity.class));
        SimpleRegistration.registerFieldBlocksFrom(BlocksBA.class, (String)"botanicadds", (CreativeTabs)TAB);
        SimpleRegistration.registerFieldItemsFrom(ItemsBA.class, (String)"botanicadds", (CreativeTabs)TAB);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init();
        GaiaPlateRecipesBA.init();
        PetalRecipesBA.init();
        AltarRecipesBA.init();
        PoolRecipesBA.init();
        ElvenTradesBA.init();
        RecipesBA.init();
        LexiconBA.init();
        ICTCompat ictc = CraftTweakerCompat.compat();
        if (ictc != null) {
            ictc.init();
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent e) {
        ICTCompat ictc = CraftTweakerCompat.compat();
        if (ictc != null) {
            ictc.onLoadComplete();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        for (Class<? extends SubTileEntity> cl : flowers) {
            Flower fl = cl.getDeclaredAnnotation(Flower.class);
            String id = "ba_" + fl.value();
            BotaniaAPI.registerSubTile((String)id, cl);
            BotaniaAPI.registerSubTileSignature(cl, (SubTileSignature)new BasicSignature(id));
            BotaniaAPI.addSubTileToCreativeMenu((String)id);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> e) {
        ResourceLocation ultraSpreader = new ResourceLocation("botania", "spreader_3");
        ForgeRegistryUtils.deleteEntry((IForgeRegistry)e.getRegistry(), (ResourceLocation)ultraSpreader);
        ModContainer c = Loader.instance().activeModContainer();
        Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get("botania"));
        e.getRegistry().register(SimpleRegistration.parseShapedRecipe((ItemStack)new ItemStack(ModBlocks.spreader, 1, 3), (Object[])new Object[]{"gsd", Character.valueOf('g'), new ItemStack(ItemsBA.GAIA_SHARD), Character.valueOf('s'), new ItemStack(ModBlocks.spreader, 1, 2), Character.valueOf('d'), "elvenDragonstone"}).setRegistryName(ultraSpreader));
        Loader.instance().setActiveModContainer(c);
    }

    static {
        LOG = LogManager.getLogger((String)"botanicadds");
        TAB = new CreativeTabs("botanicadds"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)BlocksBA.MANA_TESSERACT);
            }

            public void func_78018_a(NonNullList<ItemStack> items) {
                Item sf = Item.func_150898_a((Block)ModBlocks.specialFlower);
                for (Item item : Item.field_150901_e) {
                    item.func_150895_a((CreativeTabs)this, items);
                    if (item != sf) continue;
                    for (Class<? extends SubTileEntity> cl : flowers) {
                        Flower fl = cl.getDeclaredAnnotation(Flower.class);
                        String id = "ba_" + fl.value();
                        items.add((Object)ItemBlockSpecialFlower.ofType((String)id));
                    }
                }
            }
        };
    }
}

