/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class LootHelper {
    private static Field pools;
    private static Field lootEntries;
    private static Method getLootTable;
    private static Field itemF;
    private static Field functionsF;
    private static Field tableF;

    public static boolean hasDropped(LivingDropsEvent e, Predicate<ItemStack> drop) {
        return e.getDrops().stream().map(EntityItem::func_92059_d).anyMatch(drop);
    }

    public static LootContext generateDropContent(LivingDropsEvent e) {
        if (e.getEntityLiving().field_70170_p.field_72995_K) {
            return null;
        }
        EntityLivingBase c = e.getEntityLiving();
        LootContext.Builder ctx = new LootContext.Builder((WorldServer)c.field_70170_p).func_186472_a((Entity)c).func_186473_a(e.getSource());
        if (e.isRecentlyHit() && e.getSource() != null && e.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getSource().func_76346_g();
            ctx = ctx.func_186470_a(player).func_186469_a(player.func_184817_da());
        }
        return ctx.func_186471_a();
    }

    public static ResourceLocation getDeathTablePath(EntityLiving c) {
        ResourceLocation lootTable;
        if (getLootTable == null) {
            for (Method m : EntityLiving.class.getDeclaredMethods()) {
                if (m.getParameterCount() != 0 || !ResourceLocation.class.isAssignableFrom(m.getReturnType())) continue;
                getLootTable = m;
                getLootTable.setAccessible(true);
                break;
            }
        }
        if ((lootTable = c.field_184659_bA) == null && c.getEntityData().func_150297_b("HC_CDLT", 8)) {
            lootTable = new ResourceLocation(c.getEntityData().func_74779_i("HC_CDLT"));
        }
        if (lootTable == null) {
            try {
                lootTable = (ResourceLocation)getLootTable.invoke((Object)c, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return lootTable;
    }

    public static LootTable getDeathTable(EntityLiving c) {
        LootTable lt = c.field_70170_p.func_184146_ak().func_186521_a(LootHelper.getDeathTablePath(c));
        if (lt == null) {
            lt = LootTable.field_186464_a;
        }
        return lt;
    }

    public static Stream<LootEntry> lootEntryStream(LootTable table) {
        if (pools == null) {
            pools = LootTable.class.getDeclaredFields()[2];
            pools.setAccessible(true);
        }
        if (lootEntries == null) {
            lootEntries = LootPool.class.getDeclaredFields()[0];
            lootEntries.setAccessible(true);
        }
        try {
            List poolList = (List)List.class.cast(pools.get(table));
            return poolList.stream().flatMap(pool -> {
                try {
                    List lootEntryList = (List)List.class.cast(lootEntries.get(pool));
                    return lootEntryList.stream();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            throw new RuntimeException(err);
        }
    }

    public static NonNullList<ItemStack> getEntryItems(LootEntry entry, Random rand, LootContext context) {
        NonNullList items = NonNullList.func_191196_a();
        if (itemF == null) {
            itemF = LootEntryItem.class.getDeclaredFields()[0];
            itemF.setAccessible(true);
        }
        if (functionsF == null) {
            functionsF = LootEntryItem.class.getDeclaredFields()[1];
            functionsF.setAccessible(true);
        }
        try {
            if (entry instanceof LootEntryItem) {
                Item item = (Item)itemF.get(entry);
                LootFunction[] functions = (LootFunction[])functionsF.get(entry);
                ItemStack itemstack = new ItemStack(item);
                for (LootFunction lootfunction : functions) {
                    if (lootfunction instanceof SetCount || !LootConditionManager.func_186638_a((LootCondition[])lootfunction.func_186554_a(), (Random)rand, (LootContext)context)) continue;
                    itemstack = lootfunction.func_186553_a(itemstack, rand, context);
                }
                items.add((Object)itemstack);
            } else if (entry instanceof LootEntryTable) {
                if (tableF == null) {
                    tableF = LootEntryTable.class.getDeclaredFields()[0];
                    tableF.setAccessible(true);
                }
                LootTable table = context.func_186497_e().func_186521_a((ResourceLocation)tableF.get(entry));
                LootHelper.lootEntryStream(table).forEach(entry2 -> items.addAll(LootHelper.getEntryItems(entry2, rand, context)));
            } else {
                entry.func_186363_a((Collection)items, rand, context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return items;
    }
}

